<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Driver;
use App\Models\User;

class UpdateDriverUserId extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'driver:update-user-id';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update drivers.user_id based on matching email with users table';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $drivers = Driver::whereNull('user_id')->whereNotNull('email')->get();
        $updated = 0;
        foreach ($drivers as $driver) {
            $user = User::where('email', $driver->email)->first();
            if ($user) {
                $driver->user_id = $user->id;
                $driver->save();
                $updated++;
                $this->info("Updated driver ID {$driver->id} with user_id {$user->id}");
            }
        }
        $this->info("Total updated: $updated");
    }
}
