<?php

namespace App\Exports;

use App\Models\Expense;
use Illuminate\Support\Collection;

class ExpensesExport
{
    public function collection(): Collection
    {
        return Expense::with(['project', 'addedBy'])->get()->map(function ($expense) {
            return [
                'ID' => $expense->id,
                'Judul' => $expense->title,
                'Deskripsi' => $expense->description,
                'Jumlah (Rp)' => number_format($expense->amount, 2, ',', '.'),
                'Tanggal Pengeluaran' => $expense->expense_date->format('d/m/Y'),
                'Proyek' => $expense->project ? $expense->project->name : 'Tidak Ada Proyek',
                'Kategori' => $expense->category,
                'Metode Pembayaran' => $expense->payment_method,
                'Nomor Kwitansi' => $expense->receipt_number ?? '-',
                'Ditambahkan Oleh' => $expense->addedBy->name,
                'Tanggal Dibuat' => $expense->created_at->format('d/m/Y H:i'),
                'Terakhir Diperbarui' => $expense->updated_at->format('d/m/Y H:i')
            ];
        });
    }
}