<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DriverActivity extends Model
{
    // Tambahkan trip_id ke fillable
    protected $fillable = [
        'hari_tanggal',
        'plat_nomor',
        'asal',
        'tujuan',
        'km_start',
        'km_end',
        'pengisian_solar',
        'indikator_solar',
        'retase',
        'user_id',
        'material_np_id',
        'trip_id'
    ];
    
    // Tambahkan relasi ke Trip
    public function trip()
    {
        return $this->belongsTo(Trip::class);
    }

    protected $casts = [
        'hari_tanggal' => 'date',
        'km_start' => 'integer',
        'km_end' => 'integer',
        'pengisian_solar' => 'integer',
        'indikator_solar' => 'integer',
        'retase' => 'integer'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function materialNp()
    {
        return $this->belongsTo(MaterialNp::class, 'material_np_id');
    }
}