<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Expense extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'title',
        'description',
        'amount',
        'expense_date',
        'project_id',
        'fuel_purchase_id',
        'category',
        'payment_method',
        'receipt_number',
        'status',
        'added_by'
    ];
    
    protected $casts = [
        'expense_date' => 'date',
        'amount' => 'decimal:2'
    ];
    
    /**
     * Get the user who added this expense record
     */
    public function addedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'added_by');
    }
    
    /**
     * Get the project associated with this expense
     */
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }
    
    /**
     * Get the fuel purchase associated with this expense
     */
    public function fuelPurchase(): BelongsTo
    {
        return $this->belongsTo(FuelPurchase::class);
    }
}