<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ManualTripCount extends Model
{
    protected $fillable = [
        'driver_id', 'date', 'completed_trips', 'ongoing_trips', 'notes', 'added_by'
    ];

    /**
     * Get the driver that owns the manual trip count.
     */
    public function driver(): BelongsTo
    {
        return $this->belongsTo(Driver::class);
    }

    /**
     * Get the user who added this manual trip count.
     */
    public function addedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'added_by');
    }
}
