<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Trip extends Model
{
    protected $fillable = [
        'driver_id', 'truck_id', 'project_id', 'material_np_id', 'origin', 'destination', 'start_date', 'end_date',
        'start_odometer', 'end_odometer', 'distance', 'fuel_consumption', 'indikator_solar',
        'status', 'notes'
    ];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
    ];

    /**
     * Get the driver that owns the trip.
     */
    public function driver(): BelongsTo
    {
        return $this->belongsTo(Driver::class);
    }

    /**
     * Get the truck that was used for the trip.
     */
    public function truck(): BelongsTo
    {
        return $this->belongsTo(Truck::class);
    }

    /**
     * Get the project associated with the trip.
     */
    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    /**
     * Get the material-np associated with the trip.
     */
    public function materialNp()
    {
        return $this->belongsTo(\App\Models\MaterialNp::class, 'material_np_id');
    }

    public function driverActivities()
    {
        return $this->hasMany(\App\Models\DriverActivity::class);
    }
}
