<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TruckMaintenance extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'truck_id', 'maintenance_date', 'maintenance_type', 'description',
        'cost', 'performed_by', 'location', 'odometer_reading',
        'next_maintenance_date', 'status', 'notes',
        'notification_sent', 'last_notification_sent_at'
    ];

    protected $casts = [
        'maintenance_date' => 'date',
        'next_maintenance_date' => 'date',
        'cost' => 'decimal:2',
        'notification_sent' => 'boolean',
        'last_notification_sent_at' => 'datetime',
    ];

    /**
     * Get the truck that owns the maintenance record.
     */
    public function truck(): BelongsTo
    {
        return $this->belongsTo(Truck::class);
    }
    
    /**
     * Get maintenance type label
     */
    public function getMaintenanceTypeLabelAttribute()
    {
        $types = [
            'oil_change' => 'Penggantian Oli',
            'repair' => 'Perbaikan',
            'inspection' => 'Inspeksi',
            'tire_change' => 'Penggantian Ban',
            'filter_change' => 'Penggantian Filter',
            'brake_service' => 'Servis Rem',
            'electrical' => 'Sistem Elektrikal',
            'body_repair' => 'Perbaikan Bodi',
            'other' => 'Lainnya'
        ];
        
        return $types[$this->maintenance_type] ?? $this->maintenance_type;
    }

    public function requestedBy()
    {
        return $this->belongsTo(User::class, 'requested_by');
    }
}