<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('drivers', function (Blueprint $table) {
            // Tambahkan kolom baru jika diperlukan
            $table->string('emergency_contact')->nullable();
            $table->string('blood_type')->nullable();
            $table->string('profile_photo')->nullable();
            $table->decimal('salary', 12, 2)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('drivers', function (Blueprint $table) {
            // Hapus kolom yang ditambahkan
            $table->dropColumn([
                'emergency_contact',
                'blood_type',
                'profile_photo',
                'salary'
            ]);
        });
    }
};
