<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('truck_maintenances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('truck_id')->constrained()->onDelete('cascade');
            $table->date('maintenance_date');
            $table->string('maintenance_type'); // oil_change, repair, inspection, tire_change, etc
            $table->text('description');
            $table->decimal('cost', 12, 2)->default(0);
            $table->string('performed_by')->nullable();
            $table->string('location')->nullable();
            $table->integer('odometer_reading')->nullable(); // Khusus untuk pencatatan KM
            $table->date('next_maintenance_date')->nullable();
            $table->string('status')->default('completed'); // scheduled, in_progress, completed
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('truck_maintenances');
    }
};