<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('trips', function (Blueprint $table) {
            $table->unsignedBigInteger('material_np_id')->nullable()->after('project_id');
            $table->foreign('material_np_id')->references('id')->on('material_nps')->nullOnDelete();
        });
    }

    public function down()
    {
        Schema::table('trips', function (Blueprint $table) {
            $table->dropForeign(['material_np_id']);
            $table->dropColumn('material_np_id');
        });
    }
};
