<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('driver_activities', function (Blueprint $table) {
            $table->foreignId('material_np_id')->nullable()->constrained('material_nps')->nullOnDelete()->after('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('driver_activities', function (Blueprint $table) {
            $table->dropForeign(['material_np_id']);
            $table->dropColumn('material_np_id');
        });
    }
};
