<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('truck_maintenances', function (Blueprint $table) {
            $table->timestamp('last_manual_notification_sent_at')->nullable();
            $table->integer('manual_notification_count')->default(0);
        });
    }

    public function down()
    {
        Schema::table('truck_maintenances', function (Blueprint $table) {
            $table->dropColumn(['last_manual_notification_sent_at', 'manual_notification_count']);
        });
    }
};