<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('truck_maintenances', function (Blueprint $table) {
            // Hapus kolom lama jika ada
            $table->dropColumn(['last_manual_notification_sent_at', 'manual_notification_count']);
            
            // Tambah kolom baru untuk tracking terpisah
            $table->timestamp('last_manual_push_sent_at')->nullable();
            $table->integer('manual_push_count')->default(0);
            $table->timestamp('last_manual_inapp_sent_at')->nullable();
            $table->integer('manual_inapp_count')->default(0);
        });
    }

    public function down()
    {
        Schema::table('truck_maintenances', function (Blueprint $table) {
            $table->dropColumn([
                'last_manual_push_sent_at', 
                'manual_push_count',
                'last_manual_inapp_sent_at', 
                'manual_inapp_count'
            ]);
            
            // Restore kolom lama
            $table->timestamp('last_manual_notification_sent_at')->nullable();
            $table->integer('manual_notification_count')->default(0);
        });
    }
};