<?php

namespace Database\Seeders;

use App\Models\Material;
use App\Models\Project;
use Illuminate\Database\Seeder;

class MaterialSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Dapatkan semua proyek
        $projects = Project::where('status', 'active')->pluck('id')->toArray();
        
        // Daftar material umum untuk konstruksi
        $commonMaterials = [
            [
                'name' => 'Semen Portland',
                'description' => 'Semen untuk konstruksi umum',
                'unit' => 'sak',
                'price_per_unit' => 60000,
            ],
            [
                'name' => 'Pasir Beton',
                'description' => 'Pasir untuk campuran beton',
                'unit' => 'm³',
                'price_per_unit' => 250000,
            ],
            [
                'name' => 'Batu Split',
                'description' => 'Batu pecah untuk campuran beton',
                'unit' => 'm³',
                'price_per_unit' => 300000,
            ],
            [
                'name' => 'Besi Beton 10mm',
                'description' => 'Besi tulangan untuk konstruksi',
                'unit' => 'batang',
                'price_per_unit' => 75000,
            ],
            [
                'name' => 'Kayu Bekisting',
                'description' => 'Kayu untuk cetakan beton',
                'unit' => 'm³',
                'price_per_unit' => 2500000,
            ],
        ];
        
        // Buat material untuk setiap proyek aktif
        foreach ($projects as $projectId) {
            foreach ($commonMaterials as $material) {
                Material::create([
                    'name' => $material['name'],
                    'description' => $material['description'],
                    'unit' => $material['unit'],
                    'price_per_unit' => $material['price_per_unit'],
                    'stock' => fake()->numberBetween(10, 1000),
                    'project_id' => $projectId,
                    'notes' => fake()->optional(0.5)->sentence(),
                ]);
            }
            
            // Tambahkan 2-5 material acak untuk setiap proyek
            $randomMaterialCount = fake()->numberBetween(2, 5);
            $units = ['kg', 'ton', 'lembar', 'batang', 'roll', 'set', 'unit'];
            
            for ($i = 0; $i < $randomMaterialCount; $i++) {
                Material::create([
                    'name' => fake()->word() . ' ' . fake()->word(),
                    'description' => fake()->sentence(),
                    'unit' => fake()->randomElement($units),
                    'price_per_unit' => fake()->numberBetween(10000, 5000000),
                    'stock' => fake()->numberBetween(1, 500),
                    'project_id' => $projectId,
                    'notes' => fake()->optional(0.5)->sentence(),
                ]);
            }
        }
    }
}