<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Berikan semua izin ke admin
        $adminRole = Role::where('slug', 'admin')->first();
        $adminRole->givePermissionTo(
            'view-users', 'create-users', 'edit-users', 'delete-users',
            'view-trucks', 'create-trucks', 'edit-trucks', 'delete-trucks',
            'view-drivers', 'create-drivers', 'edit-drivers', 'delete-drivers', 'view-driver-retase',
            'view-trips', 'create-trips', 'edit-trips', 'delete-trips',
            'view-projects', 'create-projects', 'edit-projects', 'delete-projects',
            'view-reports', 'export-reports',
            'view-settings', 'edit-settings',
            'manage-users',
            'manage-roles',
            'manage-permissions',
            'access-settings',
            'manage-manual-trip-counts',
            'manage-finances' // Added financial management permission
        );

        // Berikan permission terbatas ke role manager
        $managerRole = Role::where('slug', 'manager')->first();
        $managerRole->givePermissionTo(
            'view-users',
            'view-trucks', 'create-trucks', 'edit-trucks',
            'view-drivers', 'create-drivers', 'edit-drivers', 'view-driver-retase',
            'view-trips', 'create-trips', 'edit-trips',
            'view-projects', 'create-projects', 'edit-projects',
            'view-reports', 'export-reports',
            'view-settings',
            'manage-finances' // Added financial management permission
        );

        // Berikan permission sangat terbatas ke role operator
        $operatorRole = Role::where('slug', 'operator')->first();
        $operatorRole->givePermissionTo(
            'view-trucks',
            'view-drivers', 'view-driver-retase',
            'view-trips', 'create-trips', 'edit-trips',
            'view-projects',
            'view-reports'
        );
    }
}