<?php

namespace Database\Seeders;

use App\Models\Trip;
use App\Models\Driver;
use App\Models\Truck;
use App\Models\Project;
use Illuminate\Database\Seeder;

class TripSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Dapatkan driver aktif
        $activeDrivers = Driver::where('status', 'aktif')->get();
        
        // Dapatkan truck aktif
        $activeTrucks = Truck::where('status', 'active')->pluck('id')->toArray();
        
        // Dapatkan proyek aktif
        $activeProjects = Project::where('status', 'active')->pluck('id')->toArray();
        
        // Status perjalanan yang mungkin
        $tripStatuses = ['ongoing', 'completed', 'cancelled'];
        
        // Buat beberapa trip dengan data spesifik
        Trip::create([
            'driver_id' => $activeDrivers[0]->id ?? 1,
            'truck_id' => $activeTrucks[0] ?? 1,
            'project_id' => $activeProjects[0] ?? 1,
            'start_date' => now()->subDays(5),
            'end_date' => now()->subDays(3),
            'start_odometer' => 15000.00,
            'end_odometer' => 15250.00,
            'distance' => 250.00,
            'fuel_consumption' => 50.00,
            'status' => 'completed',
            'notes' => 'Pengiriman material untuk proyek pembangunan jalan tol',
        ]);
        
        Trip::create([
            'driver_id' => $activeDrivers[1]->id ?? 1,
            'truck_id' => $activeTrucks[1] ?? 1,
            'project_id' => $activeProjects[1] ?? 1,
            'start_date' => now()->subDays(2),
            'end_date' => null,
            'start_odometer' => 22500.00,
            'end_odometer' => null,
            'distance' => null,
            'fuel_consumption' => null,
            'status' => 'ongoing',
            'notes' => 'Pengiriman material untuk proyek perumahan',
        ]);
        
        // Buat data retase yang terstruktur untuk setiap driver
        foreach ($activeDrivers as $index => $driver) {
            // Jumlah trip bervariasi untuk setiap driver (3-8 trip)
            $tripCount = fake()->numberBetween(3, 8);
            
            for ($i = 0; $i < $tripCount; $i++) {
                $startDate = fake()->dateTimeBetween('-3 months', 'now');
                $status = fake()->randomElement($tripStatuses);
                
                $endDate = null;
                $endOdometer = null;
                $distance = null;
                $fuelConsumption = null;
                
                $startOdometer = fake()->numberBetween(10000, 50000);
                
                if ($status === 'completed') {
                    $endDate = fake()->dateTimeBetween($startDate, 'now');
                    $endOdometer = $startOdometer + fake()->numberBetween(50, 500);
                    $distance = $endOdometer - $startOdometer;
                    $fuelConsumption = $distance / fake()->numberBetween(4, 8); // Konsumsi bahan bakar (km/liter)
                }
                
                Trip::create([
                    'driver_id' => $driver->id,
                    'truck_id' => $driver->truck_id ?? fake()->randomElement($activeTrucks),
                    'project_id' => fake()->randomElement($activeProjects),
                    'start_date' => $startDate,
                    'end_date' => $endDate,
                    'start_odometer' => $startOdometer,
                    'end_odometer' => $endOdometer,
                    'distance' => $distance,
                    'fuel_consumption' => $fuelConsumption,
                    'status' => $status,
                    'notes' => fake()->optional(0.7)->sentence(),
                ]);
            }
        }
        
        // Buat beberapa trip tambahan secara acak
        for ($i = 0; $i < 10; $i++) {
            $startDate = fake()->dateTimeBetween('-3 months', 'now');
            $status = fake()->randomElement($tripStatuses);
            
            $endDate = null;
            $endOdometer = null;
            $distance = null;
            $fuelConsumption = null;
            
            $startOdometer = fake()->numberBetween(10000, 50000);
            
            if ($status === 'completed') {
                $endDate = fake()->dateTimeBetween($startDate, 'now');
                $endOdometer = $startOdometer + fake()->numberBetween(50, 500);
                $distance = $endOdometer - $startOdometer;
                $fuelConsumption = $distance / fake()->numberBetween(4, 8); // Konsumsi bahan bakar (km/liter)
            }
            
            Trip::create([
                'driver_id' => $activeDrivers->random()->id,
                'truck_id' => fake()->randomElement($activeTrucks),
                'project_id' => fake()->randomElement($activeProjects),
                'start_date' => $startDate,
                'end_date' => $endDate,
                'start_odometer' => $startOdometer,
                'end_odometer' => $endOdometer,
                'distance' => $distance,
                'fuel_consumption' => $fuelConsumption,
                'status' => $status,
                'notes' => fake()->optional(0.7)->sentence(),
            ]);
        }
    }
}