<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Ringkasan Utama -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                <!-- Dashboard Card 1 -->
                <div class="bg-gradient-to-br from-indigo-50 to-indigo-100 p-5 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 border border-indigo-100 overflow-hidden relative group">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-gradient-to-r from-indigo-500 to-indigo-600 text-white mr-4 shadow-md group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                                <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                                <i class="fas fa-truck-moving text-xl relative z-10"></i>
                            </div>
                            <div>
                                <p class="text-xs uppercase tracking-wider font-semibold text-indigo-800 mb-1">Total Truk</p>
                                <p class="text-2xl font-bold text-indigo-900">{{ $truckCount }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                        <i class="fas fa-truck-moving text-6xl text-indigo-900"></i>
                    </div>
                </div>
                
                <!-- Dashboard Card 2 -->
                <div class="bg-gradient-to-br from-green-50 to-green-100 p-5 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 border border-green-100 overflow-hidden relative group">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-gradient-to-r from-green-500 to-green-600 text-white mr-4 shadow-md group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                                <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                                <i class="fas fa-user-hard-hat text-xl relative z-10"></i>
                            </div>
                            <div>
                                <p class="text-xs uppercase tracking-wider font-semibold text-green-800 mb-1">Total Driver</p>
                                <p class="text-2xl font-bold text-green-900">{{ $driverCount }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                        <i class="fas fa-user-hard-hat text-6xl text-green-900"></i>
                    </div>
                </div>
                
                <!-- Dashboard Card 3 -->
                <div class="bg-gradient-to-br from-blue-50 to-blue-100 p-5 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 border border-blue-100 overflow-hidden relative group">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-gradient-to-r from-blue-500 to-blue-600 text-white mr-4 shadow-md group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                                <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                                <i class="fas fa-building text-xl relative z-10"></i>
                            </div>
                            <div>
                                <p class="text-xs uppercase tracking-wider font-semibold text-blue-800 mb-1">Proyek Aktif</p>
                                <p class="text-2xl font-bold text-blue-900">{{ $upcomingProjects->count() }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                        <i class="fas fa-building text-6xl text-blue-900"></i>
                    </div>
                </div>
                
                <!-- Dashboard Card 4 -->
                <div class="bg-gradient-to-br from-purple-50 to-purple-100 p-5 rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 border border-purple-100 overflow-hidden relative group">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="p-3 rounded-full bg-gradient-to-r from-purple-500 to-purple-600 text-white mr-4 shadow-md group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                                <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                                <i class="fas fa-map-marked-alt text-xl relative z-10"></i>
                            </div>
                            <div>
                                <p class="text-xs uppercase tracking-wider font-semibold text-purple-800 mb-1">Trip Bulan Ini</p>
                                <p class="text-2xl font-bold text-purple-900">{{ $activeTrips }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                        <i class="fas fa-map-marked-alt text-6xl text-purple-900"></i>
                    </div>
                </div>
            </div>

            <!-- Ringkasan Keuangan -->
            <div class="bg-white overflow-hidden shadow-lg sm:rounded-lg mb-6 hover:shadow-xl transition-all duration-300">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4 text-gray-800 border-b pb-2">Ringkasan Keuangan Bulan Ini</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-4">
                        <!-- Pendapatan -->
                        <div class="bg-gradient-to-br from-green-50 to-green-100 p-4 rounded-xl shadow-md border border-green-100 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 overflow-hidden relative group">
                            <div class="flex items-center mb-2">
                                <div class="p-2 rounded-full bg-gradient-to-r from-green-500 to-green-600 text-white mr-3 group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                                    <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                                    <i class="fas fa-money-bill-wave text-sm relative z-10"></i>
                                </div>
                                <h4 class="text-sm uppercase tracking-wider font-semibold text-green-800">Pendapatan</h4>
                            </div>
                            <p class="text-2xl font-bold text-green-700">Rp {{ number_format($currentMonthIncome, 0, ',', '.') }}</p>
                            <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                                <i class="fas fa-money-bill-wave text-6xl text-green-900"></i>
                            </div>
                        </div>
                        
                        <!-- Pengeluaran -->
                        <div class="bg-gradient-to-br from-red-50 to-red-100 p-4 rounded-xl shadow-md border border-red-100 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 overflow-hidden relative group">
                            <div class="flex items-center mb-2">
                                <div class="p-2 rounded-full bg-gradient-to-r from-red-500 to-red-600 text-white mr-3 group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                                    <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                                    <i class="fas fa-file-invoice-dollar text-sm relative z-10"></i>
                                </div>
                                <h4 class="text-sm uppercase tracking-wider font-semibold text-red-800">Pengeluaran</h4>
                            </div>
                            <p class="text-2xl font-bold text-red-700">Rp {{ number_format($currentMonthExpense, 0, ',', '.') }}</p>
                            <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                                <i class="fas fa-file-invoice-dollar text-6xl text-red-900"></i>
                            </div>
                        </div>
                        
                        <!-- Profit/Loss -->
                        <div class="bg-gradient-to-br {{ ($currentMonthIncome - $currentMonthExpense) >= 0 ? 'from-emerald-50 to-emerald-100 border-emerald-100' : 'from-rose-50 to-rose-100 border-rose-100' }} p-4 rounded-xl shadow-md border hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 overflow-hidden relative group">
                            <div class="flex items-center mb-2">
                                <div class="p-2 rounded-full {{ ($currentMonthIncome - $currentMonthExpense) >= 0 ? 'bg-gradient-to-r from-emerald-500 to-emerald-600' : 'bg-gradient-to-r from-rose-500 to-rose-600' }} text-white mr-3 group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                                    <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                                    <i class="fas {{ ($currentMonthIncome - $currentMonthExpense) >= 0 ? 'fa-chart-line' : 'fa-chart-line-down' }} text-sm relative z-10"></i>
                                </div>
                                <h4 class="text-sm uppercase tracking-wider font-semibold {{ ($currentMonthIncome - $currentMonthExpense) >= 0 ? 'text-emerald-800' : 'text-rose-800' }}">Profit/Loss</h4>
                            </div>
                            <p class="text-2xl font-bold {{ ($currentMonthIncome - $currentMonthExpense) >= 0 ? 'text-emerald-700' : 'text-rose-700' }}">Rp {{ number_format($currentMonthIncome - $currentMonthExpense, 0, ',', '.') }}</p>
                            <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                                <i class="fas {{ ($currentMonthIncome - $currentMonthExpense) >= 0 ? 'fa-chart-line' : 'fa-chart-line-down' }} text-6xl {{ ($currentMonthIncome - $currentMonthExpense) >= 0 ? 'text-emerald-900' : 'text-rose-900' }}"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Grafik Keuangan -->
                    <div class="mt-4 bg-gray-50 p-4 rounded-lg shadow-inner">
                        <canvas id="financeChart" width="100%" height="50"></canvas>
                    </div>
                </div>
            </div>
            
            <!-- Informasi BBM dan Retase -->
            <div class="bg-white overflow-hidden shadow-lg sm:rounded-lg mb-6 hover:shadow-xl transition-all duration-300">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4 text-gray-800 border-b pb-2">Informasi BBM dan Retase Bulan Ini</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Pemakaian BBM Teratas -->
                        <div class="bg-gradient-to-br from-amber-50 to-amber-100 p-4 rounded-xl shadow-md border border-amber-100 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 overflow-hidden relative group">
                            <h4 class="text-sm uppercase tracking-wider font-semibold text-amber-800 mb-3 flex items-center">
                                <div class="p-2 rounded-full bg-gradient-to-r from-amber-500 to-amber-600 text-white mr-3 group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                                    <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                                    <i class="fas fa-gas-pump text-sm relative z-10"></i>
                                </div>
                                Pemakaian BBM Teratas
                            </h4>
                            @if($topFuelConsumption->count() > 0)
                                <div class="overflow-x-auto bg-white rounded-lg shadow-inner">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Truk</th>
                                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Plat Nomor</th>
                                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total BBM (Liter)</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            @foreach($topFuelConsumption as $truck)
                                                <tr class="hover:bg-gray-50 transition-colors duration-200">
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $truck->brand }} {{ $truck->model }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $truck->plate_number }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ number_format($truck->total_fuel, 0) }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <p class="text-gray-500 bg-white p-4 rounded-lg shadow-inner">Tidak ada data pemakaian BBM bulan ini.</p>
                            @endif
                            <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                                <i class="fas fa-gas-pump text-6xl text-amber-900"></i>
                            </div>
                        </div>
                        
                        <!-- Retase Teratas -->
                        <div class="bg-gradient-to-br from-sky-50 to-sky-100 p-4 rounded-xl shadow-md border border-sky-100 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 overflow-hidden relative group">
                            <h4 class="text-sm uppercase tracking-wider font-semibold text-sky-800 mb-3 flex items-center">
                                <div class="p-2 rounded-full bg-gradient-to-r from-sky-500 to-sky-600 text-white mr-3 group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                                    <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                                    <i class="fas fa-route text-sm relative z-10"></i>
                                </div>
                                Retase Teratas
                            </h4>
                            @if($topTrips->count() > 0)
                                <div class="overflow-x-auto bg-white rounded-lg shadow-inner">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Truk</th>
                                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Plat Nomor</th>
                                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jumlah Trip</th>
                                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Jarak (km)</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            @foreach($topTrips as $truck)
                                                <tr class="hover:bg-gray-50 transition-colors duration-200">
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $truck->brand }} {{ $truck->model }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $truck->plate_number }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $truck->trip_count }}</td>
                                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ number_format($truck->total_distance, 0) }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <p class="text-gray-500 bg-white p-4 rounded-lg shadow-inner">Tidak ada data retase bulan ini.</p>
                            @endif
                            <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                                <i class="fas fa-route text-6xl text-sky-900"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Proyek dan Armada -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
                <!-- Proyek dengan Deadline Terdekat -->
                <div class="bg-gradient-to-br from-emerald-50 to-emerald-100 p-4 rounded-xl shadow-md border border-emerald-100 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 overflow-hidden relative group">
                    <h4 class="text-sm uppercase tracking-wider font-semibold text-emerald-800 mb-3 flex items-center">
                        <div class="p-2 rounded-full bg-gradient-to-r from-emerald-500 to-emerald-600 text-white mr-3 group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                            <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                            <i class="fas fa-calendar-alt text-sm relative z-10"></i>
                        </div>
                        Proyek dengan Deadline Terdekat
                    </h4>
                    @if($upcomingProjects->count() > 0)
                        <div class="overflow-x-auto bg-white rounded-lg shadow-inner">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Proyek</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Klien</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Deadline</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($upcomingProjects as $project)
                                        <tr class="hover:bg-gray-50 transition-colors duration-200">
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $project->name }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $project->client->name ?? 'N/A' }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $project->end_date->format('d/m/Y') }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm">
                                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                                    {{ $project->status }}
                                                </span>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-gray-500 bg-white p-4 rounded-lg shadow-inner">Tidak ada proyek aktif dengan deadline terdekat.</p>
                    @endif
                    <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                        <i class="fas fa-calendar-alt text-6xl text-emerald-900"></i>
                    </div>
                </div>
                
                <!-- Dokumen Armada yang Perlu Diperbarui -->
                <div class="bg-gradient-to-br from-rose-50 to-rose-100 p-4 rounded-xl shadow-md border border-rose-100 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 overflow-hidden relative group">
                    <h4 class="text-sm uppercase tracking-wider font-semibold text-rose-800 mb-3 flex items-center">
                        <div class="p-2 rounded-full bg-gradient-to-r from-rose-500 to-rose-600 text-white mr-3 group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                            <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                            <i class="fas fa-file-alt text-sm relative z-10"></i>
                        </div>
                        Dokumen yang Perlu Diperbarui
                    </h4>
                    
                    <!-- STNK yang Akan Expired atau Sudah Expired -->
                    <div class="mb-4">
                        <h5 class="text-xs uppercase tracking-wider font-semibold text-rose-700 mb-2 border-b border-rose-200 pb-1">STNK yang Perlu Diperbarui</h5>
                        @if($trucksWithStnkIssues->count() > 0)
                            <div class="overflow-x-auto bg-white rounded-lg shadow-inner">
                                <table class="min-w-full divide-y divide-gray-200">
                                    <thead class="bg-gray-50">
                                        <tr>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Plat Nomor</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nomor STNK</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal Expired</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        @foreach($trucksWithStnkIssues as $truck)
                                            @php
                                                $stnkStatus = $truck->stnk_status;
                                            @endphp
                                            <tr class="hover:bg-gray-50 transition-colors duration-200">
                                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $truck->plate_number }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $truck->stnk_number }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $truck->stnk_expire_date->format('d/m/Y') }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $stnkStatus['status'] == 'overdue' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800' }}">
                                                        {{ $stnkStatus['status'] == 'overdue' ? 'Expired '.abs($stnkStatus['days']).' hari' : 'Expires dalam '.$stnkStatus['days'].' hari' }}
                                                    </span>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-gray-500 bg-white p-4 rounded-lg shadow-inner">Tidak ada STNK yang perlu diperbarui dalam 30 hari ke depan.</p>
                        @endif
                    </div>
                    
                    <!-- KIR yang Akan Expired atau Sudah Expired -->
                    <div>
                        <h5 class="text-xs uppercase tracking-wider font-semibold text-rose-700 mb-2 border-b border-rose-200 pb-1">KIR yang Perlu Diperbarui</h5>
                        @if($trucksWithKirIssues->count() > 0)
                            <div class="overflow-x-auto bg-white rounded-lg shadow-inner">
                                <table class="min-w-full divide-y divide-gray-200">
                                    <thead class="bg-gray-50">
                                        <tr>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Plat Nomor</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nomor KIR</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal Expired</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        @foreach($trucksWithKirIssues as $truck)
                                            @php
                                                $kirStatus = $truck->kir_status;
                                            @endphp
                                            <tr class="hover:bg-gray-50 transition-colors duration-200">
                                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $truck->plate_number }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $truck->kir_number }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $truck->kir_expire_date->format('d/m/Y') }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $kirStatus['status'] == 'overdue' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800' }}">
                                                        {{ $kirStatus['status'] == 'overdue' ? 'Expired '.abs($kirStatus['days']).' hari' : 'Expires dalam '.$kirStatus['days'].' hari' }}
                                                    </span>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-gray-500 bg-white p-4 rounded-lg shadow-inner">Tidak ada KIR yang perlu diperbarui dalam 30 hari ke depan.</p>
                        @endif
                    </div>
                    
                    <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                        <i class="fas fa-exclamation-triangle text-6xl text-rose-900"></i>
                    </div>
                </div>
            </div>

            <!-- Klien Teratas dan Trip Terbaru -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Klien Teratas -->
                <div class="bg-gradient-to-br from-purple-50 to-purple-100 p-4 rounded-xl shadow-md border border-purple-100 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 overflow-hidden relative group">
                    <h4 class="text-sm uppercase tracking-wider font-semibold text-purple-800 mb-3 flex items-center">
                        <div class="p-2 rounded-full bg-gradient-to-r from-purple-500 to-purple-600 text-white mr-3 group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                            <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                            <i class="fas fa-building text-sm relative z-10"></i>
                        </div>
                        Klien Teratas
                    </h4>
                    @if($topClients->count() > 0)
                        <div class="overflow-x-auto bg-white rounded-lg shadow-inner">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Klien</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jumlah Proyek</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Nilai</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($topClients as $client)
                                        <tr class="hover:bg-gray-50 transition-colors duration-200">
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $client->name }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $client->projects_count }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp {{ number_format($client->total_budget, 0, ',', '.') }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-gray-500 bg-white p-4 rounded-lg shadow-inner">Tidak ada data klien.</p>
                    @endif
                    <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                        <i class="fas fa-building text-6xl text-purple-900"></i>
                    </div>
                </div>
                
                <!-- Trip Terbaru -->
                <div class="bg-gradient-to-br from-indigo-50 to-indigo-100 p-4 rounded-xl shadow-md border border-indigo-100 hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 overflow-hidden relative group">
                    <h4 class="text-sm uppercase tracking-wider font-semibold text-indigo-800 mb-3 flex items-center">
                        <div class="p-2 rounded-full bg-gradient-to-r from-indigo-500 to-indigo-600 text-white mr-3 group-hover:scale-110 transition-transform duration-300 relative overflow-hidden">
                            <div class="absolute inset-0 bg-white opacity-0 group-hover:opacity-20 rounded-full transition-opacity duration-300"></div>
                            <i class="fas fa-map-marked-alt text-sm relative z-10"></i>
                        </div>
                        Trip Terbaru
                    </h4>
                    @if($recentTrips->count() > 0)
                        <div class="overflow-x-auto bg-white rounded-lg shadow-inner">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Truk</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Driver</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Proyek</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    <!-- Bagian Trip Terbaru - Perbaikan pada baris 429-433 -->
                                    @foreach($recentTrips as $trip)
                                        <tr class="hover:bg-gray-50 transition-colors duration-200">
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $trip->start_date->format('d/m/Y') }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $trip->truck->plate_number }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $trip->driver->name }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $trip->project->name ?? 'N/A' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-gray-500 bg-white p-4 rounded-lg shadow-inner">Tidak ada data trip terbaru.</p>
                    @endif
                    <div class="absolute -bottom-2 -right-2 opacity-10 transform group-hover:scale-110 group-hover:opacity-20 transition-all duration-500">
                        <i class="fas fa-map-marked-alt text-6xl text-indigo-900"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Grafik Keuangan
        const ctxFinance = document.getElementById('financeChart').getContext('2d');
        new Chart(ctxFinance, {
            type: 'bar',
            data: {
                labels: ['Pendapatan', 'Pengeluaran', 'Profit/Loss'],
                datasets: [{
                    label: 'Jumlah (Rp)',
                    data: [
                        {{ $currentMonthIncome }}, 
                        {{ $currentMonthExpense }}, 
                        {{ $currentMonthIncome - $currentMonthExpense }}
                    ],
                    backgroundColor: [
                        'rgba(16, 185, 129, 0.7)',  // Green for income
                        'rgba(239, 68, 68, 0.7)',   // Red for expense
                        {{ ($currentMonthIncome - $currentMonthExpense) >= 0 ? 'rgba(16, 185, 129, 0.7)' : 'rgba(239, 68, 68, 0.7)' }}  // Green/Red for profit/loss
                    ],
                    borderColor: [
                        'rgb(16, 185, 129)',
                        'rgb(239, 68, 68)',
                        {{ ($currentMonthIncome - $currentMonthExpense) >= 0 ? 'rgb(16, 185, 129)' : 'rgb(239, 68, 68)' }}
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    },
                    title: {
                        display: true,
                        text: 'Ringkasan Keuangan Bulan Ini'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return 'Rp ' + value.toLocaleString('id-ID');
                            }
                        }
                    }
                }
            }
        });
    </script>
    @endpush
</x-app-layout>
