<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Riwayat Aktivitas Driver') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @foreach($activities as $date => $dailyActivities)
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                    <div class="p-6 text-gray-900">
                        <h3 class="text-lg font-semibold mb-4">{{ \Carbon\Carbon::parse($date)->format('d F Y') }}</h3>
                        
                        <div class="overflow-x-auto">
                            <table class="min-w-full bg-white">
                                <thead class="bg-gray-100">
                                    <tr>
                                        <th class="py-2 px-4 border-b text-left">Plat Nomor</th>
                                        <th class="py-2 px-4 border-b text-left">Rute</th>
                                        <th class="py-2 px-4 border-b text-left">KM Awal</th>
                                        <th class="py-2 px-4 border-b text-left">KM Akhir</th>
                                        <th class="py-2 px-4 border-b text-left">Pengisian Solar</th>
                                        <th class="py-2 px-4 border-b text-left">Retase</th>
                                        <th class="py-2 px-4 border-b text-left">Driver</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($dailyActivities as $activity)
                                        <tr>
                                            <td class="py-2 px-4 border-b">{{ $activity->plat_nomor }}</td>
                                            <td class="py-2 px-4 border-b">{{ $activity->asal }} - {{ $activity->tujuan }}</td>
                                            <td class="py-2 px-4 border-b">{{ number_format($activity->km_start) }}</td>
                                            <td class="py-2 px-4 border-b">{{ number_format($activity->km_end) }}</td>
                                            <td class="py-2 px-4 border-b">{{ number_format($activity->pengisian_solar) }}</td>
                                            <td class="py-2 px-4 border-b">{{ $activity->retase }}</td>
                                            <td class="py-2 px-4 border-b">{{ $activity->user->name ?? 'Unknown' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</x-app-layout>