<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Tambah Driver') }}
            </h2>
            <a href="{{ route('drivers.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-arrow-left mr-2"></i>Kembali
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form method="POST" action="{{ route('drivers.store') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Nama -->
                            <div>
                                <x-input-label for="name" :value="__('Nama')" />
                                <x-text-input id="name" class="block mt-1 w-full" type="text" name="name" :value="old('name')" required autofocus />
                                <x-input-error :messages="$errors->get('name')" class="mt-2" />
                            </div>

                            <!-- Nomor KTP -->
                            <div>
                                <x-input-label for="id_number" :value="__('Nomor KTP')" />
                                <x-text-input id="id_number" class="block mt-1 w-full" type="text" name="id_number" :value="old('id_number')" required />
                                <x-input-error :messages="$errors->get('id_number')" class="mt-2" />
                            </div>

                            <!-- Assign Armada -->
                            <div>
                                <x-input-label for="truck_id" :value="__('Assign Armada')" />
                                <select id="truck_id" name="truck_id" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full">
                                    <option value="">Pilih Armada</option>
                                    @foreach ($trucks as $truck)
                                        @php
                                            // Cek apakah truk memiliki driver yang ter-assign
                                            $hasDriver = App\Models\Driver::where('truck_id', $truck->id)
                                                ->where('status', 'aktif')
                                                ->exists();
                                            $optionClass = $hasDriver ? 'bg-red-100' : 'bg-green-100';
                                            $optionText = $hasDriver ? '🔴 ' : '🟢 ';
                                        @endphp
                                        <option value="{{ $truck->id }}" {{ old('truck_id') == $truck->id ? 'selected' : '' }} class="{{ $optionClass }}">
                                            {{ $optionText }}{{ $truck->plate_number }} - {{ $truck->brand }} {{ $truck->model }}
                                        </option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('truck_id')" class="mt-2" />
                            </div>

                            <!-- Nomor SIM -->
                            <div>
                                <x-input-label for="license_number" :value="__('Nomor SIM')" />
                                <x-text-input id="license_number" class="block mt-1 w-full" type="text" name="license_number" :value="old('license_number')" required />
                                <x-input-error :messages="$errors->get('license_number')" class="mt-2" />
                            </div>

                            <!-- Tanggal Kadaluarsa SIM -->
                            <div>
                                <x-input-label for="license_expiry" :value="__('Tanggal Kadaluarsa SIM')" />
                                <x-text-input id="license_expiry" class="block mt-1 w-full" type="date" name="license_expiry" :value="old('license_expiry')" required />
                                <x-input-error :messages="$errors->get('license_expiry')" class="mt-2" />
                            </div>

                            <!-- Telepon -->
                            <div>
                                <x-input-label for="phone" :value="__('Telepon')" />
                                <x-text-input id="phone" class="block mt-1 w-full" type="text" name="phone" :value="old('phone')" required />
                                <x-input-error :messages="$errors->get('phone')" class="mt-2" />
                            </div>

                            <!-- Status -->
                            <div>
                                <x-input-label for="status" :value="__('Status')" />
                                <select id="status" name="status" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
                                    <option value="">Pilih Status</option>
                                    <option value="aktif" {{ old('status') == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="cuti" {{ old('status') == 'cuti' ? 'selected' : '' }}>Cuti</option>
                                    <option value="tidak aktif" {{ old('status') == 'tidak aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                                </select>
                                <x-input-error :messages="$errors->get('status')" class="mt-2" />
                            </div>

                            <!-- Tanggal Bergabung -->
                            <div>
                                <x-input-label for="join_date" :value="__('Tanggal Bergabung')" />
                                <x-text-input id="join_date" class="block mt-1 w-full" type="date" name="join_date" :value="old('join_date')" required />
                                <x-input-error :messages="$errors->get('join_date')" class="mt-2" />
                            </div>

                            <!-- Tanggal Keluar -->
                            <div>
                                <x-input-label for="exit_date" :value="__('Tanggal Keluar')" />
                                <x-text-input id="exit_date" class="block mt-1 w-full" type="date" name="exit_date" :value="old('exit_date')" />
                                <x-input-error :messages="$errors->get('exit_date')" class="mt-2" />
                            </div>

                            <!-- Kontak Darurat -->
                            <div>
                                <x-input-label for="emergency_contact" :value="__('Kontak Darurat')" />
                                <x-text-input id="emergency_contact" class="block mt-1 w-full" type="text" name="emergency_contact" :value="old('emergency_contact')" />
                                <x-input-error :messages="$errors->get('emergency_contact')" class="mt-2" />
                            </div>

                            <!-- Golongan Darah -->
                            <div>
                                <x-input-label for="blood_type" :value="__('Golongan Darah')" />
                                <select id="blood_type" name="blood_type" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full">
                                    <option value="">Pilih Golongan Darah</option>
                                    <option value="A" {{ old('blood_type') == 'A' ? 'selected' : '' }}>A</option>
                                    <option value="B" {{ old('blood_type') == 'B' ? 'selected' : '' }}>B</option>
                                    <option value="AB" {{ old('blood_type') == 'AB' ? 'selected' : '' }}>AB</option>
                                    <option value="O" {{ old('blood_type') == 'O' ? 'selected' : '' }}>O</option>
                                </select>
                                <x-input-error :messages="$errors->get('blood_type')" class="mt-2" />
                            </div>

                            <!-- Gaji -->
                            <div>
                                <x-input-label for="salary" :value="__('Gaji')" />
                                <x-text-input id="salary" class="block mt-1 w-full" type="number" name="salary" :value="old('salary')" step="0.01" />
                                <x-input-error :messages="$errors->get('salary')" class="mt-2" />
                            </div>

                            <!-- Foto Profil -->
                            <div>
                                <x-input-label for="profile_photo" :value="__('Foto Profil')" />
                                <input id="profile_photo" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" type="file" name="profile_photo" />
                                <x-input-error :messages="$errors->get('profile_photo')" class="mt-2" />
                            </div>
                        </div>

                        <!-- Alamat -->
                        <div class="mt-4">
                            <x-input-label for="address" :value="__('Alamat')" />
                            <textarea id="address" name="address" rows="3" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>{{ old('address') }}</textarea>
                            <x-input-error :messages="$errors->get('address')" class="mt-2" />
                        </div>

                        <!-- Catatan -->
                        <div class="mt-4">
                            <x-input-label for="notes" :value="__('Catatan')" />
                            <textarea id="notes" name="notes" rows="4" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full">{{ old('notes') }}</textarea>
                            <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button>
                                {{ __('Simpan') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>