@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Detail Pendapatan</h1>
        <div class="flex space-x-2">
            <a href="{{ route('incomes.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-medium py-2 px-4 rounded-md transition-all duration-150">
                <i class="fas fa-arrow-left mr-2"></i> Kembali
            </a>
            <a href="{{ route('incomes.edit', $income) }}" class="bg-yellow-500 hover:bg-yellow-600 text-white font-medium py-2 px-4 rounded-md transition-all duration-150">
                <i class="fas fa-edit mr-2"></i> Edit
            </a>
        </div>
    </div>

    @include('components.alert')

    <div class="bg-white rounded-lg shadow-md overflow-hidden mb-6">
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <h2 class="text-lg font-semibold text-gray-800 mb-4">Informasi Pendapatan</h2>
                    <table class="w-full">
                        <tr>
                            <td class="py-2 text-gray-600 font-medium">Judul</td>
                            <td class="py-2 text-gray-800">{{ $income->title }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-gray-600 font-medium">Jumlah</td>
                            <td class="py-2 text-gray-800">Rp {{ number_format($income->amount, 0, ',', '.') }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-gray-600 font-medium">Tanggal</td>
                            <td class="py-2 text-gray-800">{{ $income->income_date->format('d/m/Y') }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-gray-600 font-medium">Kategori</td>
                            <td class="py-2 text-gray-800">{{ $income->category }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-gray-600 font-medium">Metode Pembayaran</td>
                            <td class="py-2 text-gray-800">{{ $income->payment_method }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-gray-600 font-medium">Nomor Kwitansi</td>
                            <td class="py-2 text-gray-800">{{ $income->receipt_number ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-gray-600 font-medium">Proyek</td>
                            <td class="py-2 text-gray-800">{{ $income->project ? $income->project->name : 'Tidak ada' }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-gray-600 font-medium">Deskripsi</td>
                            <td class="py-2 text-gray-800">{{ $income->description ?? '-' }}</td>
                        </tr>
                    </table>
                </div>
                
                <div>
                    <h2 class="text-lg font-semibold text-gray-800 mb-4">Status Approval</h2>
                    <div class="mb-4">
                        @if($income->approval_status == 'pending')
                            <span class="px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-sm font-medium">Menunggu Approval</span>
                        @elseif($income->approval_status == 'approved')
                            <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-sm font-medium">Disetujui</span>
                        @elseif($income->approval_status == 'rejected')
                            <span class="px-3 py-1 bg-red-100 text-red-800 rounded-full text-sm font-medium">Ditolak</span>
                        @endif
                    </div>
                    
                    @if($income->approval_status != 'pending' && $income->approvedBy)
                    <table class="w-full">
                        <tr>
                            <td class="py-2 text-gray-600 font-medium">Disetujui/Ditolak Oleh</td>
                            <td class="py-2 text-gray-800">{{ $income->approvedBy->name }}</td>
                        </tr>
                        <tr>
                            <td class="py-2 text-gray-600 font-medium">Tanggal Approval</td>
                            <td class="py-2 text-gray-800">{{ $income->approved_at ? $income->approved_at->format('d/m/Y H:i') : '-' }}</td>
                        </tr>
                    </table>
                    @endif
                    
                    @can('manage-finances')
                        @if($income->approval_status == 'pending')
                            <div class="mt-4 flex space-x-2">
                                <form id="approvalForm" action="{{ route('incomes.approve', $income) }}" method="POST">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-medium py-2 px-4 rounded-md transition-all duration-150">
                                        <i class="fas fa-check mr-2"></i> Setujui
                                    </button>
                                </form>
                                
                                <script>
                                document.getElementById('approvalForm').addEventListener('submit', function(e) {
                                    e.preventDefault();
                                    
                                    const formData = new FormData(this);
                                    
                                    fetch(this.action, {
                                        method: 'POST',
                                        headers: {
                                            'Accept': 'application/json',
                                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                        },
                                        body: formData
                                    })
                                    .then(response => response.json())
                                    .then(data => {
                                        if (data.success) {
                                            Swal.fire({
                                                title: 'Berhasil!',
                                                text: 'Pendapatan telah disetujui',
                                                icon: 'success',
                                                showConfirmButton: true,
                                                confirmButtonText: 'OK',
                                                confirmButtonColor: '#10B981',
                                                timer: 3000,
                                                timerProgressBar: true,
                                                customClass: {
                                                    popup: 'animate__animated animate__fadeInDown'
                                                }
                                            }).then(() => {
                                                window.location.reload();
                                            });
                                        } else {
                                            Swal.fire({
                                                title: 'Gagal!',
                                                text: data.message || 'Terjadi kesalahan saat menyetujui pendapatan',
                                                icon: 'error'
                                            });
                                        }
                                    })
                                    .catch(error => {
                                        console.error('Error:', error);
                                        Swal.fire({
                                            title: 'Error!',
                                            text: 'Terjadi kesalahan pada server',
                                            icon: 'error'
                                        });
                                    });
                                });
                                </script>
                                
                                <form action="{{ route('incomes.reject', $income) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-medium py-2 px-4 rounded-md transition-all duration-150">
                                        <i class="fas fa-times mr-2"></i> Tolak
                                    </button>
                                </form>
                            </div>
                        @endif
                    @endcan
                    
                    <h2 class="text-lg font-semibold text-gray-800 mt-6 mb-4">Bukti Pembayaran</h2>
                    @if($income->payment_proof)
                        <div class="border rounded-lg p-4">
                            <a href="{{ Storage::url($income->payment_proof) }}" target="_blank" class="text-indigo-600 hover:text-indigo-800 flex items-center">
                                <i class="fas fa-file-alt text-2xl mr-2"></i>
                                <span>Lihat Bukti Pembayaran</span>
                            </a>
                        </div>
                    @else
                        <p class="text-gray-500 italic">Tidak ada bukti pembayaran</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="p-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">Informasi Tambahan</h2>
            <table class="w-full">
                <tr>
                    <td class="py-2 text-gray-600 font-medium">Ditambahkan Oleh</td>
                    <td class="py-2 text-gray-800">{{ $income->addedBy->name }}</td>
                </tr>
                <tr>
                    <td class="py-2 text-gray-600 font-medium">Tanggal Dibuat</td>
                    <td class="py-2 text-gray-800">{{ $income->created_at->format('d/m/Y H:i') }}</td>
                </tr>
                <tr>
                    <td class="py-2 text-gray-600 font-medium">Terakhir Diperbarui</td>
                    <td class="py-2 text-gray-800">{{ $income->updated_at->format('d/m/Y H:i') }}</td>
                </tr>
            </table>
        </div>
    </div>
</div>
@endsection