<div class="flex flex-col h-full">
    <!-- Sidebar Header -->  
    <div class="flex items-center justify-between px-4 py-3">
        <div class="flex items-center">
            <span class="text-2xl font-bold text-white mr-1" x-show="$store.sidebar.expanded"
                  x-transition:enter="transition ease-out duration-200 delay-100"
                  x-transition:enter-start="opacity-0 transform translate-x-2"
                  x-transition:enter-end="opacity-100 transform translate-x-0"
                  x-transition:leave="transition ease-in duration-150"
                  x-transition:leave-start="opacity-100 transform translate-x-0"
                  x-transition:leave-end="opacity-0 transform translate-x-2">OBM</span>
            <span class="text-2xl font-bold text-white mr-1" x-show="$store.sidebar.expanded"
                  x-transition:enter="transition ease-out duration-200 delay-100"
                  x-transition:enter-start="opacity-0 transform translate-x-2"
                  x-transition:enter-end="opacity-100 transform translate-x-0"
                  x-transition:leave="transition ease-in duration-150"
                  x-transition:leave-start="opacity-100 transform translate-x-0"
                  x-transition:leave-end="opacity-0 transform translate-x-2">System</span>
        </div>
        <!-- Toggle button for desktop -->
        <button @click="$store.sidebar.toggle()" 
                class="p-1 rounded-md hover:bg-indigo-700 focus:outline-none transition-colors duration-200 hidden md:block">
            <i class="fas text-white transition-transform duration-200" 
               :class="{
                   'fa-chevron-left': $store.sidebar.expanded, 
                   'fa-chevron-right': !$store.sidebar.expanded
               }"></i>
        </button>
        <!-- Mobile menu button -->
        <button @click="$store.sidebar.toggleMobile()" 
                class="p-2 rounded-md hover:bg-indigo-700 focus:outline-none transition-colors duration-200 md:hidden">
            <i class="fas fa-bars text-white text-xl"></i>
        </button>
    </div>

    <!-- Navigation Links -->  
    <div class="flex-1 px-2 py-4 space-y-1 overflow-y-auto sidebar-content">
        <!-- Dashboard -->
        <a href="{{ route('dashboard') }}" 
           class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg mb-1 transition-all duration-150 {{ request()->routeIs('dashboard') ? 'bg-white/10 text-white shadow-sm' : 'text-indigo-100 hover:bg-white/5' }}">
            <i class="fas fa-tachometer-alt w-5 text-center {{ request()->routeIs('dashboard') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
            <span x-show="$store.sidebar.expanded" 
                  x-transition:enter="transition ease-out duration-200 delay-100"
                  x-transition:enter-start="opacity-0 transform translate-x-2"
                  x-transition:enter-end="opacity-100 transform translate-x-0"
                  x-transition:leave="transition ease-in duration-150"
                  x-transition:leave-start="opacity-100 transform translate-x-0"
                  x-transition:leave-end="opacity-0 transform translate-x-2"
                  class="ml-3 whitespace-nowrap">Dashboard</span>
        </a>

        <!-- Manajemen Armada -->  
        <div x-data="{menuOpen: {{ request()->routeIs('trucks.*') || request()->routeIs('drivers.*') || request()->routeIs('fuel-purchases.*') ? 'true' : 'false' }}}">
            <button @click="$store.sidebar.closeOtherMenus($el.parentElement); menuOpen = !menuOpen" 
                    class="w-full group flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-lg text-indigo-100 hover:bg-white/5 transition-all duration-150 focus:outline-none"
                    :class="{ 'bg-white/10': menuOpen }">
                <div class="flex items-center">
                    <i class="fas fa-truck w-5 text-center text-indigo-300 group-hover:text-white"></i>
                    <span x-show="$store.sidebar.expanded" 
                          x-transition:enter="transition ease-out duration-200 delay-100"
                          x-transition:enter-start="opacity-0 transform translate-x-2"
                          x-transition:enter-end="opacity-100 transform translate-x-0"
                          x-transition:leave="transition ease-in duration-150"
                          x-transition:leave-start="opacity-100 transform translate-x-0"
                          x-transition:leave-end="opacity-0 transform translate-x-2"
                          class="ml-3 whitespace-nowrap">Armada</span>
                </div>
                <i x-show="$store.sidebar.expanded" 
                   class="fas text-xs transition-transform duration-200" 
                   :class="{'fa-chevron-down transform rotate-180': menuOpen, 'fa-chevron-down': !menuOpen}"></i>
            </button>
            <div x-show="menuOpen && $store.sidebar.expanded" 
                 x-transition:enter="transition ease-out duration-200" 
                 x-transition:enter-start="opacity-0 -translate-y-1" 
                 x-transition:enter-end="opacity-100 translate-y-0" 
                 x-transition:leave="transition ease-in duration-150"
                 x-transition:leave-start="opacity-100 translate-y-0"
                 x-transition:leave-end="opacity-0 -translate-y-1"
                 class="mt-1 space-y-1 pl-2">
                <!-- Sub-menu items -->
                <a href="{{ route('trucks.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('trucks.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-truck-moving w-5 text-center {{ request()->routeIs('trucks.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Truk</span>
                </a>
                <a href="{{ route('drivers.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('drivers.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-id-card w-5 text-center {{ request()->routeIs('drivers.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Driver</span>
                </a>
                <a href="{{ route('fuel-purchases.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('fuel-purchases.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-gas-pump w-5 text-center {{ request()->routeIs('fuel-purchases.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Bahan Bakar</span>
                </a>
                <!-- Tambahkan menu Maintenance Truk -->
                <a href="{{ route('truck-maintenances.all') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('truck-maintenances.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-tools w-5 text-center {{ request()->routeIs('truck-maintenances.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Maintenance Truk</span>
                </a>
            </div>
        </div>

        <!-- Manajemen Operasional -->
        <div x-data="{menuOpen: {{ request()->routeIs('trips.*') || request()->routeIs('projects.*') || request()->routeIs('materials.*') ? 'true' : 'false' }} }" class="mb-1" x-id="['dropdown-button']">
            <button @click="Alpine.store('sidebar').closeOtherMenus($el.parentElement); menuOpen = !menuOpen" class="w-full flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-lg text-indigo-100 hover:bg-white/5 transition-all duration-150 focus:outline-none">
                <div class="flex items-center">
                    <i class="fas fa-route w-5 text-center text-indigo-300 group-hover:text-white"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Operasional</span>
                </div>
                <i x-show="$store.sidebar.expanded" class="fas text-xs transition-transform duration-200" :class="{'fa-chevron-down transform rotate-0': menuOpen, 'fa-chevron-right transform -rotate-90': !menuOpen}"></i>
            </button>
            <div x-show="menuOpen" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" class="mt-1 space-y-1 pl-2">
                <a href="{{ route('trips.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('trips.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-map-marked-alt w-5 text-center {{ request()->routeIs('trips.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Trip/Perjalanan</span>
                </a>
                <!-- Ganti link yang ada dengan: -->
                <a href="{{ route('projects.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('projects.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-project-diagram w-5 text-center {{ request()->routeIs('projects.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Proyek</span>
                </a>
                <a href="{{ route('materials.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('materials.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-boxes w-5 text-center {{ request()->routeIs('materials.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Material</span>
                </a>
                <a href="{{ route('material-np.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('material-np.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-cube w-5 text-center {{ request()->routeIs('material-np.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Material-NP</span>
                </a>
            </div>
        </div>

        <!-- Divider -->
        <div x-show="$store.sidebar.expanded" class="my-2 border-t border-indigo-700/30"></div>

        <!-- Manajemen Klien -->
        <a href="{{ route('clients.index') }}" class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg mb-1 transition-all duration-150 {{ request()->routeIs('clients.*') ? 'bg-white/10 text-white shadow-sm' : 'text-indigo-100 hover:bg-white/5' }}">
            <i class="fas fa-users w-5 text-center {{ request()->routeIs('clients.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
            <span x-show="$store.sidebar.expanded" class="ml-3">Klien</span>
        </a>

        <!-- Manajemen Keuangan -->
        <div x-data="{menuOpen: {{ request()->routeIs('expenses.*') ? 'true' : 'false' }} }" class="mb-1" x-id="['dropdown-button']">
            <button @click="Alpine.store('sidebar').closeOtherMenus($el.parentElement); menuOpen = !menuOpen" class="w-full flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-lg text-indigo-100 hover:bg-white/5 transition-all duration-150 focus:outline-none">
                <div class="flex items-center">
                    <i class="fas fa-money-bill-wave w-5 text-center text-indigo-300 group-hover:text-white"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Keuangan</span>
                </div>
                <i x-show="$store.sidebar.expanded" class="fas text-xs transition-transform duration-200" :class="{'fa-chevron-down transform rotate-0': menuOpen, 'fa-chevron-right transform -rotate-90': !menuOpen}"></i>
            </button>
            <div x-show="menuOpen" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" class="mt-1 space-y-1 pl-2">
                <a href="{{ route('expenses.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('expenses.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-file-invoice-dollar w-5 text-center {{ request()->routeIs('expenses.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Pengeluaran</span>
                </a>
                <a href="{{ route('incomes.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('incomes.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-hand-holding-usd w-5 text-center {{ request()->routeIs('incomes.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Pendapatan</span>
                </a>
                <a href="{{ route('reports.financial') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('reports.financial') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-chart-pie w-5 text-center {{ request()->routeIs('reports.financial') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Laporan Keuangan</span>
                </a>
            </div>
        </div>

        <!-- Laporan dan Analitik -->
        <div x-data="{menuOpen: {{ request()->routeIs('reports.*') ? 'true' : 'false' }} }" class="mb-1" x-id="['dropdown-button']">
            <button @click="Alpine.store('sidebar').closeOtherMenus($el.parentElement); menuOpen = !menuOpen" class="w-full flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-lg text-indigo-100 hover:bg-white/5 transition-all duration-150 focus:outline-none">
                <div class="flex items-center">
                    <i class="fas fa-chart-line w-5 text-center text-indigo-300 group-hover:text-white"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Laporan & Analitik</span>
                </div>
                <i x-show="$store.sidebar.expanded" class="fas text-xs transition-transform duration-200" :class="{'fa-chevron-down transform rotate-0': menuOpen, 'fa-chevron-right transform -rotate-90': !menuOpen}"></i>
            </button>
            <div x-show="menuOpen" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" class="mt-1 space-y-1 pl-2">
                <a href="{{ route('reports.trips') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('reports.trips') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-truck-loading w-5 text-center {{ request()->routeIs('reports.trips') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Laporan Trip</span>
                </a>
                <a href="{{ route('reports.fuel') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('reports.fuel') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-gas-pump w-5 text-center {{ request()->routeIs('reports.fuel') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Laporan Bahan Bakar</span>
                </a>
                <a href="{{ route('reports.expenses') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('reports.expenses') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-file-invoice w-5 text-center {{ request()->routeIs('reports.expenses') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Laporan Pengeluaran</span>
                </a>
                <a href="{{ route('reports.projects') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('reports.projects') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-tasks w-5 text-center {{ request()->routeIs('reports.projects') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Laporan Proyek</span>
                </a>
            </div>
        </div>

        <!-- Divider -->
        <div x-show="$store.sidebar.expanded" class="my-2 border-t border-indigo-700/30"></div>

        <!-- Pengumuman -->
        <a href="{{ route('announcements.index') }}" class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg mb-1 transition-all duration-150 {{ request()->routeIs('announcements.*') ? 'bg-white/10 text-white shadow-sm' : 'text-indigo-100 hover:bg-white/5' }}">
            <i class="fas fa-bullhorn w-5 text-center {{ request()->routeIs('announcements.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
            <span x-show="$store.sidebar.expanded" class="ml-3">Pengumuman</span>
        </a>

        <!-- Administrasi Sistem -->
        <div x-data="{menuOpen: {{ request()->routeIs('settings.*') || request()->routeIs('users.*') || request()->routeIs('roles.*') || request()->routeIs('permissions.*') ? 'true' : 'false' }}}" class="mb-1" x-id="['dropdown-button']">
            <button @click="Alpine.store('sidebar').closeOtherMenus($el.parentElement); menuOpen = !menuOpen" class="w-full flex items-center justify-between px-3 py-2.5 text-sm font-medium rounded-lg text-indigo-100 hover:bg-white/5 transition-all duration-150 focus:outline-none">
                <div class="flex items-center">
                    <i class="fas fa-cogs w-5 text-center text-indigo-300 group-hover:text-white"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Sistem Settings</span>
                </div>
                <i x-show="$store.sidebar.expanded" class="fas text-xs transition-transform duration-200" :class="{'fa-chevron-down transform rotate-0': menuOpen, 'fa-chevron-right transform -rotate-90': !menuOpen}"></i>
            </button>
            <div x-show="menuOpen" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 -translate-y-1" x-transition:enter-end="opacity-100 translate-y-0" class="mt-1 space-y-1 pl-2">
                <a href="{{ route('users.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('users.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-users w-5 text-center {{ request()->routeIs('users.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Pengguna</span>
                </a>
                <a href="{{ route('roles.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('roles.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-user-tag w-5 text-center {{ request()->routeIs('roles.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Peran</span>
                </a>
                <a href="{{ route('permissions.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('permissions.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-key w-5 text-center {{ request()->routeIs('permissions.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Izin</span>
                </a>
                <a href="{{ route('settings.index') }}" class="group flex items-center px-3 py-2 text-xs font-medium rounded-md text-indigo-100 hover:bg-white/5 transition-all duration-150 {{ request()->routeIs('settings.*') ? 'bg-white/10 text-white' : '' }}">
                    <i class="fas fa-sliders-h w-5 text-center {{ request()->routeIs('settings.*') ? 'text-white' : 'text-indigo-300 group-hover:text-white' }}"></i>
                    <span x-show="$store.sidebar.expanded" class="ml-3">Pengaturan Sistem</span>
                </a>
            </div>
        </div>
    </nav>
    <!-- Expand Sidebar Button (Bottom) -->
    <button 
        x-show="!$store.sidebar.expanded && !$store.sidebar.mobileMenuOpen"
        @click="$store.sidebar.toggle()"
        class="w-full flex items-center justify-center py-3 bg-indigo-700 text-white rounded-t-lg shadow-lg transition-all duration-200 absolute bottom-0 left-0 hidden md:flex"
        style="z-index:99;"
    >
        <i class="fas fa-chevron-right text-white text-lg"></i>
    </button>
</div>