<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Bahan Bakar</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 20px; }
        .summary { margin-bottom: 20px; }
        .summary-box { border: 1px solid #ddd; padding: 10px; margin-bottom: 10px; background-color: #f9f9f9; }
        .text-right { text-align: right; }
        .receipt-image { width: 50px; height: 50px; object-fit: cover; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Laporan Bahan Bakar</h1>
        <p>Periode: {{ \Carbon\Carbon::parse($startDate)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($endDate)->format('d/m/Y') }}</p>
    </div>
    
    <div class="summary">
        <h2>Ringkasan</h2>
        <div class="summary-box">
            <p><strong>Total Pengisian:</strong> {{ $fuelPurchases->count() }}</p>
            <p><strong>Total Volume:</strong> {{ number_format($totalVolume, 1, ',', '.') }} liter</p>
            <p><strong>Total Biaya:</strong> Rp {{ number_format($totalCost, 0, ',', '.') }}</p>
        </div>
    </div>
    
    <h2>Daftar Pengisian Bahan Bakar</h2>
    @if($fuelPurchases->count() > 0)
        <table>
            <thead>
                <tr>
                    <th>Tanggal</th>
                    <th>Truk</th>
                    <th>Jenis BBM</th>
                    <th>Volume (L)</th>
                    <th>Harga/L</th>
                    <th>Total Biaya</th>
                    <th>Lokasi</th>
                    <th>Struk</th>
                </tr>
            </thead>
            <tbody>
                @foreach($fuelPurchases as $purchase)
                    <tr>
                        <td>{{ $purchase->purchase_date->format('d/m/Y') }}</td>
                        <td>{{ $purchase->truck->license_plate }}</td>
                        <td>{{ $purchase->fuel_type }}</td>
                        <td class="text-right">{{ number_format($purchase->quantity, 1, ',', '.') }}</td>
                        <td class="text-right">Rp {{ number_format($purchase->price_per_liter, 0, ',', '.') }}</td>
                        <td class="text-right">Rp {{ number_format($purchase->total_cost, 0, ',', '.') }}</td>
                        <td>{{ $purchase->location }}</td>
                        <td>
                            @if($purchase->receipt_image)
                                <img src="{{ public_path('storage/' . $purchase->receipt_image) }}" class="receipt-image" alt="Struk BBM">
                            @else
                                Tidak ada struk
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p>Tidak ada data pengisian bahan bakar yang sesuai dengan filter.</p>
    @endif
</body>
</html>