<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Proyek</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 20px; }
        .text-right { text-align: right; }
        .text-green { color: green; }
        .text-red { color: red; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Laporan Proyek</h1>
        <p>Periode: {{ \Carbon\Carbon::parse($startDate)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($endDate)->format('d/m/Y') }}</p>
    </div>
    
    <table>
        <thead>
            <tr>
                <th>Proyek</th>
                <th>Klien</th>
                <th>Jumlah Perjalanan</th>
                <th>Total Jarak (km)</th>
                <th>Total Muatan (ton)</th>
                <th>Pengeluaran (Rp)</th>
                <th>Pendapatan (Rp)</th>
                <th>Profit (Rp)</th>
            </tr>
        </thead>
        <tbody>
            @forelse($projectStats as $stat)
                <tr>
                    <td>{{ $stat['project']->name }}</td>
                    <td>{{ $stat['project']->client ? $stat['project']->client->name : 'Tidak Ada' }}</td>
                    <td>{{ $stat['trips_count'] }}</td>
                    <td class="text-right">{{ number_format($stat['total_distance'], 2, ',', '.') }}</td>
                    <td class="text-right">{{ number_format($stat['total_load'], 2, ',', '.') }}</td>
                    <td class="text-right">{{ number_format($stat['expenses_total'], 2, ',', '.') }}</td>
                    <td class="text-right">{{ number_format($stat['incomes_total'], 2, ',', '.') }}</td>
                    <td class="text-right {{ $stat['profit'] >= 0 ? 'text-green' : 'text-red' }}">
                        {{ number_format($stat['profit'], 2, ',', '.') }}
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" style="text-align: center;">Tidak ada data proyek yang tersedia.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>