<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Detail Peran') }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ route('roles.edit', $role) }}" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="{{ route('roles.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Informasi Peran -->
                        <div class="md:col-span-1">
                            <div class="bg-gray-100 p-4 rounded-lg">
                                <div class="w-full flex items-center justify-center bg-indigo-100 rounded p-4">
                                    <i class="fas fa-user-tag text-6xl text-indigo-400"></i>
                                </div>
                                
                                <div class="mt-4 text-center">
                                    <h3 class="text-xl font-semibold">{{ $role->name }}</h3>
                                    <p class="text-gray-600 mt-2">
                                        <span class="px-2 py-1 rounded text-xs font-semibold inline-block bg-indigo-100 text-indigo-800">{{ $role->slug }}</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Detail Peran -->
                        <div class="md:col-span-2">
                            <h3 class="text-lg font-semibold mb-4 pb-2 border-b">Informasi Peran</h3>
                            
                            <div class="grid grid-cols-1 gap-4 mb-6">
                                <div>
                                    <p class="text-gray-600 mb-1">Deskripsi</p>
                                    <p class="font-medium">{{ $role->description ?? 'Tidak ada deskripsi' }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Tanggal Dibuat</p>
                                    <p class="font-medium">{{ $role->created_at->format('d/m/Y') }}</p>
                                </div>
                                
                                <div>
                                    <p class="text-gray-600 mb-1">Terakhir Diperbarui</p>
                                    <p class="font-medium">{{ $role->updated_at->format('d/m/Y H:i') }}</p>
                                </div>
                            </div>
                            
                            <h3 class="text-lg font-semibold mt-6 mb-4 pb-2 border-b">Izin yang Dimiliki</h3>
                            
                            <div class="flex flex-wrap gap-2">
                                @forelse ($role->permissions as $permission)
                                    <span class="px-3 py-1 rounded-full text-sm font-semibold bg-green-100 text-green-800">
                                        {{ $permission->name }}
                                    </span>
                                @empty
                                    <span class="text-gray-500">Tidak ada izin yang ditetapkan</span>
                                @endforelse
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>