<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Detail Perjalanan') }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ route('trips.edit', $trip) }}" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="{{ route('trips.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Perjalanan</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">ID Perjalanan</p>
                                    <p>{{ $trip->id }}</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Status</p>
                                    <p>
                                        @if($trip->status == 'ongoing')
                                            <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">Sedang Berlangsung</span>
                                        @elseif($trip->status == 'completed')
                                            <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">Selesai</span>
                                        @elseif($trip->status == 'cancelled')
                                            <span class="px-2 py-1 text-xs rounded-full bg-red-100 text-red-800">Dibatalkan</span>
                                        @endif
                                    </p>
                                </div>
                                
                                <!-- Tambahkan kolom Asal -->
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Asal</p>
                                    <p>{{ $trip->origin ?? '-' }}</p>
                                </div>
                                
                                <!-- Tambahkan kolom Tujuan -->
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Tujuan</p>
                                    <p>{{ $trip->destination ?? '-' }}</p>
                                </div>
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Material (dari Driver Activity)</p>
                                    @if($trip->driverActivities->count())
                                        <ul>
                                            @foreach($trip->driverActivities as $activity)
                                                <li>
                                                    {{ $activity->materialNp ? $activity->materialNp->name . ' (' . $activity->materialNp->unit . ')' : '-' }}
                                                </li>
                                            @endforeach
                                        </ul>
                                    @else
                                        <p>-</p>
                                    @endif
                                </div>
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Material</p>
                                    <p>{{ $trip->materialNp ? $trip->materialNp->name . ' (' . $trip->materialNp->unit . ')' : '-' }}</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Tanggal Mulai</p>
                                    <p>{{ $trip->start_date->format('d/m/Y H:i') }}</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Tanggal Selesai</p>
                                    <p>{{ $trip->end_date ? $trip->end_date->format('d/m/Y H:i') : '-' }}</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Odometer Awal</p>
                                    <p>{{ number_format($trip->start_odometer, 2) }} km</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Odometer Akhir</p>
                                    <p>{{ $trip->end_odometer ? number_format($trip->end_odometer, 2) . ' km' : '-' }}</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Jarak Tempuh</p>
                                    <p>{{ $trip->distance ? number_format($trip->distance, 2) . ' km' : '-' }}</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Konsumsi BBM</p>
                                    <p>{{ $trip->fuel_consumption ? number_format($trip->fuel_consumption, 2) . ' liter' : '-' }}</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Indikator Solar</p>
                                    <p>{{ $trip->indikator_solar ? number_format($trip->indikator_solar, 2) . ' liter' : '-' }}</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Terkait</h3>
                            
                            <div class="grid grid-cols-1 gap-4">
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Driver</p>
                                    <p>{{ $trip->driver->name }}</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Truk</p>
                                    <p>{{ $trip->truck->plate_number }} - {{ $trip->truck->brand }} {{ $trip->truck->model }}</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Proyek</p>
                                    <p>{{ $trip->project->name ?? 'Tidak ada' }}</p>
                                </div>
                                
                                <div class="text-sm">
                                    <p class="font-medium text-gray-500">Catatan</p>
                                    <p class="whitespace-pre-line">{{ $trip->notes ?? 'Tidak ada catatan' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-6 flex justify-between">
                        <div>
                            <p class="text-sm text-gray-500">Dibuat: {{ $trip->created_at->format('d/m/Y H:i') }}</p>
                            <p class="text-sm text-gray-500">Diperbarui: {{ $trip->updated_at->format('d/m/Y H:i') }}</p>
                        </div>
                        
                        <form action="{{ route('trips.destroy', $trip) }}" method="POST" class="inline-block">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded" onclick="return confirm('Apakah Anda yakin ingin menghapus perjalanan ini?')">
                                <i class="fas fa-trash mr-2"></i>Hapus Perjalanan
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>