<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Daftar Seluruh Maintenance Truk') }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ route('trucks.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-truck mr-2"></i>Daftar Truk
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <!-- Filter Form - Responsive Grid -->
                    <div class="mb-4">
                        <form method="GET" action="{{ route('truck-maintenances.all') }}" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                            <div>
                                <input type="text" name="search" value="{{ request('search') }}" 
                                    class="w-full rounded-md border-gray-300" 
                                    placeholder="Cari berdasarkan plat nomor, tipe, atau lokasi...">
                            </div>
                            <div>
                                <select name="status" class="w-full rounded-md border-gray-300">
                                    <option value="">Semua Status</option>
                                    <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Request dari Driver</option>
                                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Selesai</option>
                                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Menunggu</option>
                                    <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>Dalam Proses</option>
                                </select>
                            </div>
                            <div>
                                <select name="maintenance_type" class="w-full rounded-md border-gray-300">
                                    <option value="">Semua Tipe</option>
                                    <option value="oil_change" {{ request('maintenance_type') == 'oil_change' ? 'selected' : '' }}>Penggantian Oli</option>
                                    <option value="repair" {{ request('maintenance_type') == 'repair' ? 'selected' : '' }}>Perbaikan</option>
                                    <option value="inspection" {{ request('maintenance_type') == 'inspection' ? 'selected' : '' }}>Inspeksi</option>
                                    <option value="tire_change" {{ request('maintenance_type') == 'tire_change' ? 'selected' : '' }}>Penggantian Ban</option>
                                    <option value="filter_change" {{ request('maintenance_type') == 'filter_change' ? 'selected' : '' }}>Penggantian Filter</option>
                                    <option value="brake_service" {{ request('maintenance_type') == 'brake_service' ? 'selected' : '' }}>Servis Rem</option>
                                    <option value="electrical" {{ request('maintenance_type') == 'electrical' ? 'selected' : '' }}>Sistem Elektrikal</option>
                                    <option value="body_repair" {{ request('maintenance_type') == 'body_repair' ? 'selected' : '' }}>Perbaikan Bodi</option>
                                    <option value="other" {{ request('maintenance_type') == 'other' ? 'selected' : '' }}>Lainnya</option>
                                </select>
                            </div>
                            <div class="flex space-x-2">
                                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-md hover:bg-blue-600 flex-1">
                                    <i class="fas fa-search mr-2"></i>Cari
                                </button>
                                <a href="{{ route('truck-maintenances.all') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 flex-1 text-center">
                                    <i class="fas fa-redo mr-2"></i>Reset
                                </a>
                            </div>
                        </form>
                    </div>

                    <!-- Desktop Table View -->
                    <div class="hidden lg:block overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="py-2 px-4 border-b text-left">Plat Nomor</th>
                                    <th class="py-2 px-4 border-b text-left">Tanggal</th>
                                    <th class="py-2 px-4 border-b text-left">Tipe</th>
                                    <th class="py-2 px-4 border-b text-left">Deskripsi</th>
                                    <th class="py-2 px-4 border-b text-left">Biaya</th>
                                    <th class="py-2 px-4 border-b text-left">Lokasi</th>
                                    <!-- Hapus baris ini: <th class="py-2 px-4 border-b text-left">Direquest Oleh</th> -->
                                    <th class="py-2 px-4 border-b text-left">Status</th>
                                    <th class="py-2 px-4 border-b text-left">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($maintenances as $maintenance)
                                    <tr class="hover:bg-gray-50">
                                        <td class="py-2 px-4 border-b">
                                            <a href="{{ route('trucks.show', $maintenance->truck) }}" class="text-blue-500 hover:text-blue-700">
                                                {{ $maintenance->truck->plate_number }}
                                            </a>
                                        </td>
                                        <td class="py-2 px-4 border-b">{{ $maintenance->maintenance_date ? $maintenance->maintenance_date->format('d/m/Y') : 'Belum dijadwalkan' }}</td>
                                        <td class="py-2 px-4 border-b">{{ ucfirst(str_replace('_', ' ', $maintenance->maintenance_type)) }}</td>
                                        <td class="py-2 px-4 border-b">{{ Str::limit($maintenance->description, 50) }}</td>
                                        <td class="py-2 px-4 border-b">Rp {{ number_format($maintenance->cost, 0, ',', '.') }}</td>
                                        <td class="py-2 px-4 border-b">{{ $maintenance->location }}</td>
                                        <!-- Hapus seluruh blok td ini:
                                        <td class="py-2 px-4 border-b">
                                            @if($maintenance->requested_by)
                                                {{ $maintenance->requestedBy->name ?? 'Driver' }}
                                                <br><small class="text-gray-500">{{ $maintenance->requested_at?->format('d/m/Y H:i') }}</small>
                                            @else
                                                Admin
                                            @endif
                                        </td>
                                        -->
                                        <td class="py-2 px-4 border-b">
                                            <span class="px-2 py-1 rounded text-xs font-semibold
                                                {{ $maintenance->status == 'completed' ? 'bg-green-100 text-green-800' : '' }}
                                                {{ $maintenance->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                                {{ $maintenance->status == 'in_progress' ? 'bg-blue-100 text-blue-800' : '' }}
                                                {{ $maintenance->status == 'draft' ? 'bg-orange-100 text-orange-800' : '' }}">
                                                @if($maintenance->status == 'draft')
                                                    Request dari Driver
                                                @else
                                                    {{ ucfirst(str_replace('_', ' ', $maintenance->status)) }}
                                                @endif
                                            </span>
                                        </td>
                                        <td class="py-2 px-4 border-b">
                                            <div class="flex space-x-2">
                                                @if($maintenance->status == 'draft')
                                                    <a href="{{ route('truck-maintenances.edit', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                                        class="text-blue-500 hover:text-blue-700" title="Review & Approve">
                                                        <i class="fas fa-check-circle"></i>
                                                    </a>
                                                    <a href="{{ route('truck-maintenances.show', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                                        class="text-green-500 hover:text-green-700" title="Detail">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <form action="{{ route('truck-maintenances.destroy', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                                        method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menolak request ini?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="text-red-500 hover:text-red-700" title="Tolak Request">
                                                            <i class="fas fa-times-circle"></i>
                                                        </button>
                                                    </form>
                                                @else
                                                    <a href="{{ route('truck-maintenances.edit', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                                        class="text-blue-500 hover:text-blue-700" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="{{ route('truck-maintenances.show', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                                        class="text-green-500 hover:text-green-700" title="Detail">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <form action="{{ route('truck-maintenances.destroy', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                                        method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus data ini?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="text-red-500 hover:text-red-700" title="Hapus">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="py-4 px-4 border-b text-center text-gray-500">
                                            Tidak ada data maintenance
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Mobile/Tablet Card View -->
                    <div class="lg:hidden space-y-4">
                        @forelse($maintenances as $maintenance)
                            <div class="bg-white border rounded-lg p-4 shadow-sm">
                                <div class="flex justify-between items-start mb-3">
                                    <div>
                                        <h3 class="font-semibold text-lg">
                                            <a href="{{ route('trucks.show', $maintenance->truck) }}" class="text-blue-500 hover:text-blue-700">
                                                {{ $maintenance->truck->plate_number }}
                                            </a>
                                        </h3>
                                        <p class="text-sm text-gray-600">{{ ucfirst(str_replace('_', ' ', $maintenance->maintenance_type)) }}</p>
                                    </div>
                                    <span class="px-2 py-1 rounded text-xs font-semibold
                                        {{ $maintenance->status == 'completed' ? 'bg-green-100 text-green-800' : '' }}
                                        {{ $maintenance->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                        {{ $maintenance->status == 'in_progress' ? 'bg-blue-100 text-blue-800' : '' }}
                                        {{ $maintenance->status == 'draft' ? 'bg-orange-100 text-orange-800' : '' }}">
                                        @if($maintenance->status == 'draft')
                                            Request dari Driver
                                        @else
                                            {{ ucfirst(str_replace('_', ' ', $maintenance->status)) }}
                                        @endif
                                    </span>
                                </div>
                                
                                <div class="grid grid-cols-2 gap-2 text-sm mb-3">
                                    <div>
                                        <span class="font-medium text-gray-600">Tanggal:</span>
                                        <p>{{ $maintenance->maintenance_date ? $maintenance->maintenance_date->format('d/m/Y') : 'Belum dijadwalkan' }}</p>
                                    </div>
                                    <div>
                                        <span class="font-medium text-gray-600">Biaya:</span>
                                        <p>Rp {{ number_format($maintenance->cost, 0, ',', '.') }}</p>
                                    </div>
                                    <div>
                                        <span class="font-medium text-gray-600">Lokasi:</span>
                                        <p>{{ $maintenance->location }}</p>
                                    </div>
                                    <!-- Hapus seluruh blok div ini:
                                    <div>
                                        <span class="font-medium text-gray-600">Direquest Oleh:</span>
                                        <p>
                                            @if($maintenance->requested_by)
                                                {{ $maintenance->requestedBy->name ?? 'Driver' }}
                                                <br><small class="text-gray-500">{{ $maintenance->requested_at?->format('d/m/Y H:i') }}</small>
                                            @else
                                                Admin
                                            @endif
                                        </p>
                                    </div>
                                    -->
                                </div>
                                
                                <div class="mb-3">
                                    <span class="font-medium text-gray-600">Deskripsi:</span>
                                    <p class="text-sm">{{ $maintenance->description }}</p>
                                </div>
                                
                                <div class="flex justify-end space-x-3">
                                    @if($maintenance->status == 'draft')
                                        <a href="{{ route('truck-maintenances.edit', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                            class="bg-blue-500 text-white px-3 py-1 rounded text-sm hover:bg-blue-600">
                                            <i class="fas fa-check-circle mr-1"></i>Review
                                        </a>
                                        <a href="{{ route('truck-maintenances.show', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                            class="bg-green-500 text-white px-3 py-1 rounded text-sm hover:bg-green-600">
                                            <i class="fas fa-eye mr-1"></i>Detail
                                        </a>
                                        <form action="{{ route('truck-maintenances.destroy', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                            method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menolak request ini?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="bg-red-500 text-white px-3 py-1 rounded text-sm hover:bg-red-600">
                                                <i class="fas fa-times-circle mr-1"></i>Tolak
                                            </button>
                                        </form>
                                    @else
                                        <a href="{{ route('truck-maintenances.edit', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                            class="bg-blue-500 text-white px-3 py-1 rounded text-sm hover:bg-blue-600">
                                            <i class="fas fa-edit mr-1"></i>Edit
                                        </a>
                                        <a href="{{ route('truck-maintenances.show', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                            class="bg-green-500 text-white px-3 py-1 rounded text-sm hover:bg-green-600">
                                            <i class="fas fa-eye mr-1"></i>Detail
                                        </a>
                                        <form action="{{ route('truck-maintenances.destroy', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                            method="POST" class="inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus data ini?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="bg-red-500 text-white px-3 py-1 rounded text-sm hover:bg-red-600">
                                                <i class="fas fa-trash mr-1"></i>Hapus
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-8 text-gray-500">
                                Tidak ada data maintenance
                            </div>
                        @endforelse
                    </div>

                    <div class="mt-4">
                        {{ $maintenances->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>

<td class="py-2 px-4 border-b">
    @if($maintenance->requested_by)
        {{ $maintenance->requestedBy->name ?? 'Driver' }}
        <br><small class="text-gray-500">{{ $maintenance->requested_at?->format('d/m/Y H:i') }}</small>
    @else
        Admin
    @endif
</td>

