<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Edit Riwayat Maintenance') }}
                @if(isset($truck))
                    - {{ $truck->plate_number }}
                @endif
            </h2>
            @if(isset($truck))
                <a href="{{ route('trucks.show', $truck) }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            @endif
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form action="{{ route('truck-maintenances.update', [$truck, $maintenance]) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <x-input-label for="maintenance_date" :value="__('Tanggal Maintenance')" />
                                <x-text-input id="maintenance_date" class="block mt-1 w-full" type="date" name="maintenance_date" :value="old('maintenance_date', $maintenance->maintenance_date->format('Y-m-d'))" required autofocus />
                                <x-input-error :messages="$errors->get('maintenance_date')" class="mt-2" />
                            </div>
                            
                            <div>
                                <x-input-label for="maintenance_type" :value="__('Jenis Maintenance')" />
                                <select id="maintenance_type" name="maintenance_type" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
                                    <option value="">Pilih Jenis Maintenance</option>
                                    <option value="oil_change" {{ old('maintenance_type', $maintenance->maintenance_type) == 'oil_change' ? 'selected' : '' }}>Penggantian Oli</option>
                                    <option value="repair" {{ old('maintenance_type', $maintenance->maintenance_type) == 'repair' ? 'selected' : '' }}>Perbaikan</option>
                                    <option value="inspection" {{ old('maintenance_type', $maintenance->maintenance_type) == 'inspection' ? 'selected' : '' }}>Inspeksi</option>
                                    <option value="tire_change" {{ old('maintenance_type', $maintenance->maintenance_type) == 'tire_change' ? 'selected' : '' }}>Penggantian Ban</option>
                                    <option value="filter_change" {{ old('maintenance_type', $maintenance->maintenance_type) == 'filter_change' ? 'selected' : '' }}>Penggantian Filter</option>
                                    <option value="brake_service" {{ old('maintenance_type', $maintenance->maintenance_type) == 'brake_service' ? 'selected' : '' }}>Servis Rem</option>
                                    <option value="electrical" {{ old('maintenance_type', $maintenance->maintenance_type) == 'electrical' ? 'selected' : '' }}>Sistem Elektrikal</option>
                                    <option value="body_repair" {{ old('maintenance_type', $maintenance->maintenance_type) == 'body_repair' ? 'selected' : '' }}>Perbaikan Bodi</option>
                                    <option value="other" {{ old('maintenance_type', $maintenance->maintenance_type) == 'other' ? 'selected' : '' }}>Lainnya</option>
                                </select>
                                <x-input-error :messages="$errors->get('maintenance_type')" class="mt-2" />
                            </div>
                            
                            <div class="md:col-span-2">
                                <x-input-label for="description" :value="__('Deskripsi Pekerjaan')" />
                                <textarea id="description" name="description" rows="3" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>{{ old('description', $maintenance->description) }}</textarea>
                                <x-input-error :messages="$errors->get('description')" class="mt-2" />
                            </div>
                            
                            <div>
                                <x-input-label for="cost" :value="__('Biaya')" />
                                <x-text-input id="cost" class="block mt-1 w-full" type="number" name="cost" :value="old('cost', $maintenance->cost)" min="0" step="0.01" required />
                                <x-input-error :messages="$errors->get('cost')" class="mt-2" />
                            </div>
                            
                            <div>
                                <x-input-label for="performed_by" :value="__('Dikerjakan Oleh')" />
                                <x-text-input id="performed_by" class="block mt-1 w-full" type="text" name="performed_by" :value="old('performed_by', $maintenance->performed_by)" />
                                <x-input-error :messages="$errors->get('performed_by')" class="mt-2" />
                            </div>
                            
                            <div>
                                <x-input-label for="location" :value="__('Lokasi')" />
                                <x-text-input id="location" class="block mt-1 w-full" type="text" name="location" :value="old('location', $maintenance->location)" />
                                <x-input-error :messages="$errors->get('location')" class="mt-2" />
                            </div>
                            
                            <div id="odometer_container">
                                <x-input-label for="odometer_reading" :value="__('Kilometer (KM)')" />
                                <x-text-input id="odometer_reading" class="block mt-1 w-full" type="number" name="odometer_reading" :value="old('odometer_reading', $maintenance->odometer_reading)" min="0" />
                                <x-input-error :messages="$errors->get('odometer_reading')" class="mt-2" />
                            </div>
                            
                            <div>
                                <x-input-label for="next_maintenance_date" :value="__('Tanggal Maintenance Berikutnya')" />
                                <x-text-input id="next_maintenance_date" class="block mt-1 w-full" type="date" name="next_maintenance_date" :value="old('next_maintenance_date', $maintenance->next_maintenance_date ? $maintenance->next_maintenance_date->format('Y-m-d') : '')" />
                                <x-input-error :messages="$errors->get('next_maintenance_date')" class="mt-2" />
                            </div>
                            
                            <div>
                                <x-input-label for="status" :value="__('Status')" />
                                <select id="status" name="status" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
                                    <option value="scheduled" {{ old('status', $maintenance->status) == 'scheduled' ? 'selected' : '' }}>Dijadwalkan</option>
                                    <option value="in_progress" {{ old('status', $maintenance->status) == 'in_progress' ? 'selected' : '' }}>Sedang Dikerjakan</option>
                                    <option value="completed" {{ old('status', $maintenance->status) == 'completed' ? 'selected' : '' }}>Selesai</option>
                                </select>
                                <x-input-error :messages="$errors->get('status')" class="mt-2" />
                            </div>
                            
                            <div class="md:col-span-2">
                                <x-input-label for="notes" :value="__('Catatan Tambahan')" />
                                <textarea id="notes" name="notes" rows="3" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full">{{ old('notes', $maintenance->notes) }}</textarea>
                                <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                            </div>
                        </div>
                        
                        <div class="flex items-center justify-end mt-6">
                            <x-primary-button>
                                {{ __('Simpan Perubahan') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const maintenanceTypeSelect = document.getElementById('maintenance_type');
            const odometerContainer = document.getElementById('odometer_container');
            const odometerInput = document.getElementById('odometer_reading');
            const nextMaintenanceDateInput = document.getElementById('next_maintenance_date');
            
            function toggleOdometerVisibility() {
                if (maintenanceTypeSelect.value === 'oil_change') {
                    odometerContainer.classList.remove('hidden');
                    odometerInput.setAttribute('required', 'required');
                    nextMaintenanceDateInput.setAttribute('required', 'required');
                } else {
                    odometerContainer.classList.add('hidden');
                    odometerInput.removeAttribute('required');
                    nextMaintenanceDateInput.removeAttribute('required');
                }
            }
            
            // Initial check
            toggleOdometerVisibility();
            
            // Listen for changes
            maintenanceTypeSelect.addEventListener('change', toggleOdometerVisibility);
        });
    </script>
</x-app-layout>