<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Daftar Maintenance Truk') }}
            </h2>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <!-- Tambahkan di bagian header -->
                    <div class="mb-4">
                        <button onclick="openBulkNotificationModal()" 
                            class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                            <i class="fas fa-bullhorn mr-2"></i>Kirim Notifikasi Massal
                        </button>
                    </div>
                    
                    <!-- Tambahkan checkbox di tabel untuk select multiple -->
                    <!-- Dan modal untuk bulk notification -->
                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="py-2 px-4 border-b text-left">Plat Nomor</th>
                                    <th class="py-2 px-4 border-b text-left">Tanggal</th>
                                    <th class="py-2 px-4 border-b text-left">Tipe</th>
                                    <th class="py-2 px-4 border-b text-left">Deskripsi</th>
                                    <th class="py-2 px-4 border-b text-left">Biaya</th>
                                    <th class="py-2 px-4 border-b text-left">Lokasi</th>
                                    <th class="py-2 px-4 border-b text-left">Status</th>
                                    <th class="py-2 px-4 border-b text-left">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($maintenances as $maintenance)
                                    <tr>
                                        <td class="py-2 px-4 border-b">
                                            <a href="{{ route('trucks.show', $maintenance->truck) }}" class="text-blue-500 hover:text-blue-700">
                                                {{ $maintenance->truck->plate_number }}
                                            </a>
                                        </td>
                                        <td class="py-2 px-4 border-b">{{ $maintenance->maintenance_date->format('d/m/Y') }}</td>
                                        <td class="py-2 px-4 border-b">{{ ucfirst(str_replace('_', ' ', $maintenance->maintenance_type)) }}</td>
                                        <td class="py-2 px-4 border-b">{{ $maintenance->description }}</td>
                                        <td class="py-2 px-4 border-b">{{ number_format($maintenance->cost, 0) }}</td>
                                        <td class="py-2 px-4 border-b">{{ $maintenance->location }}</td>
                                        <td class="py-2 px-4 border-b">
                                            <span class="px-2 py-1 rounded text-xs font-semibold
                                                {{ $maintenance->status == 'completed' ? 'bg-green-100 text-green-800' : '' }}
                                                {{ $maintenance->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                                {{ $maintenance->status == 'in_progress' ? 'bg-blue-100 text-blue-800' : '' }}">
                                                {{ ucfirst(str_replace('_', ' ', $maintenance->status)) }}
                                            </span>
                                        </td>
                                        <td class="py-2 px-4 border-b">
                                            <a href="{{ route('truck-maintenances.edit', ['truck' => $maintenance->truck, 'maintenance' => $maintenance]) }}" 
                                                class="text-blue-500 hover:text-blue-700 mr-2">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $maintenances->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>