<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Edit Truk') }}
            </h2>
            <a href="{{ route('trucks.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-arrow-left mr-2"></i>Kembali
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form action="{{ route('trucks.update', $truck) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <!-- Nomor Plat -->
                            <div>
                                <x-input-label for="plate_number" :value="__('Nomor Plat')" />
                                <x-text-input id="plate_number" class="block mt-1 w-full" type="text" name="plate_number" :value="old('plate_number', $truck->plate_number)" required autofocus />
                                <x-input-error :messages="$errors->get('plate_number')" class="mt-2" />
                            </div>

                            <!-- Merek -->
                            <div>
                                <x-input-label for="brand" :value="__('Merek')" />
                                <x-text-input id="brand" class="block mt-1 w-full" type="text" name="brand" :value="old('brand', $truck->brand)" required />
                                <x-input-error :messages="$errors->get('brand')" class="mt-2" />
                            </div>

                            <!-- Model -->
                            <div>
                                <x-input-label for="model" :value="__('Model')" />
                                <x-text-input id="model" class="block mt-1 w-full" type="text" name="model" :value="old('model', $truck->model)" required />
                                <x-input-error :messages="$errors->get('model')" class="mt-2" />
                            </div>

                            <!-- Tahun -->
                            <div>
                                <x-input-label for="year" :value="__('Tahun')" />
                                <x-text-input id="year" class="block mt-1 w-full" type="number" name="year" :value="old('year', $truck->year)" min="1900" max="{{ date('Y') + 1 }}" required />
                                <x-input-error :messages="$errors->get('year')" class="mt-2" />
                            </div>

                            <!-- Kapasitas -->
                            <div>
                                <x-input-label for="capacity" :value="__('Kapasitas')" />
                                <x-text-input id="capacity" class="block mt-1 w-full" type="text" name="capacity" :value="old('capacity', $truck->capacity)" required placeholder="contoh: 8 ton" />
                                <x-input-error :messages="$errors->get('capacity')" class="mt-2" />
                            </div>

                            <!-- Jenis Bahan Bakar -->
                            <div>
                                <x-input-label for="fuel_type" :value="__('Jenis Bahan Bakar')" />
                                <select id="fuel_type" name="fuel_type" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
                                    <option value="">Pilih Jenis Bahan Bakar</option>
                                    <option value="Solar" {{ old('fuel_type', $truck->fuel_type) == 'Solar' ? 'selected' : '' }}>Solar</option>
                                    <option value="Bensin" {{ old('fuel_type', $truck->fuel_type) == 'Bensin' ? 'selected' : '' }}>Bensin</option>
                                    <option value="Pertamax" {{ old('fuel_type', $truck->fuel_type) == 'Pertamax' ? 'selected' : '' }}>Pertamax</option>
                                </select>
                                <x-input-error :messages="$errors->get('fuel_type')" class="mt-2" />
                            </div>

                            <!-- Status -->
                            <div>
                                <x-input-label for="status" :value="__('Status')" />
                                <select id="status" name="status" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
                                    <option value="">Pilih Status</option>
                                    <option value="active" {{ old('status', $truck->status) == 'active' ? 'selected' : '' }}>Aktif</option>
                                    <option value="maintenance" {{ old('status', $truck->status) == 'maintenance' ? 'selected' : '' }}>Maintenance</option>
                                    <option value="inactive" {{ old('status', $truck->status) == 'inactive' ? 'selected' : '' }}>Tidak Aktif</option>
                                </select>
                                <x-input-error :messages="$errors->get('status')" class="mt-2" />
                            </div>

                            <!-- Tanggal Pembelian -->
                            <div>
                                <x-input-label for="purchase_date" :value="__('Tanggal Pembelian')" />
                                <x-text-input id="purchase_date" class="block mt-1 w-full" type="date" name="purchase_date" :value="old('purchase_date', $truck->purchase_date->format('Y-m-d'))" required />
                                <x-input-error :messages="$errors->get('purchase_date')" class="mt-2" />
                            </div>

                            <!-- Tanggal Service Terakhir -->
                            <div>
                                <x-input-label for="last_service_date" :value="__('Tanggal Service Terakhir')" />
                                <x-text-input id="last_service_date" class="block mt-1 w-full" type="date" name="last_service_date" :value="old('last_service_date', $truck->last_service_date ? $truck->last_service_date->format('Y-m-d') : '')" />
                                <x-input-error :messages="$errors->get('last_service_date')" class="mt-2" />
                            </div>

                            <!-- Tanggal Service Berikutnya -->
                            <div>
                                <x-input-label for="next_service_date" :value="__('Tanggal Service Berikutnya')" />
                                <x-text-input id="next_service_date" class="block mt-1 w-full" type="date" name="next_service_date" :value="old('next_service_date', $truck->next_service_date ? $truck->next_service_date->format('Y-m-d') : '')" />
                                <x-input-error :messages="$errors->get('next_service_date')" class="mt-2" />
                            </div>
                            
                            <!-- Nomor STNK -->
                            <div>
                                <x-input-label for="stnk_number" :value="__('Nomor STNK')" />
                                <x-text-input id="stnk_number" class="block mt-1 w-full" type="text" name="stnk_number" :value="old('stnk_number', $truck->stnk_number)" />
                                <x-input-error :messages="$errors->get('stnk_number')" class="mt-2" />
                            </div>
                            
                            <!-- Tanggal Berlaku STNK -->
                            <div>
                                <x-input-label for="stnk_expire_date" :value="__('Tanggal Berlaku STNK')" />
                                <x-text-input id="stnk_expire_date" class="block mt-1 w-full" type="date" name="stnk_expire_date" :value="old('stnk_expire_date', $truck->stnk_expire_date ? $truck->stnk_expire_date->format('Y-m-d') : '')" />
                                <x-input-error :messages="$errors->get('stnk_expire_date')" class="mt-2" />
                            </div>
                            
                            <!-- Nomor KIR -->
                            <div>
                                <x-input-label for="kir_number" :value="__('Nomor KIR')" />
                                <x-text-input id="kir_number" class="block mt-1 w-full" type="text" name="kir_number" :value="old('kir_number', $truck->kir_number)" />
                                <x-input-error :messages="$errors->get('kir_number')" class="mt-2" />
                            </div>
                            
                            <!-- Tanggal Berlaku KIR -->
                            <div>
                                <x-input-label for="kir_expire_date" :value="__('Tanggal Berlaku KIR')" />
                                <x-text-input id="kir_expire_date" class="block mt-1 w-full" type="date" name="kir_expire_date" :value="old('kir_expire_date', $truck->kir_expire_date ? $truck->kir_expire_date->format('Y-m-d') : '')" />
                                <x-input-error :messages="$errors->get('kir_expire_date')" class="mt-2" />
                            </div>
                        </div>

                        <!-- Catatan -->
                        <div class="mb-6">
                            <x-input-label for="notes" :value="__('Catatan')" />
                            <textarea id="notes" name="notes" rows="4" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full">{{ old('notes', $truck->notes) }}</textarea>
                            <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button>
                                {{ __('Simpan Perubahan') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>