<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\DriverActivityController;
use App\Http\Controllers\MaterialController;
use App\Http\Controllers\Api\MaterialNpApiController;
use App\Http\Controllers\TruckMaintenanceController;

// Login (public route)
Route::post('/login', [AuthController::class, 'login']);

// Grup route yang memerlukan autentikasi Sanctum
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', [AuthController::class, 'user']);

    // Driver Activity
    Route::post('/driver-activity', [DriverActivityController::class, 'store']);
    Route::get('/driver-activities', [DriverActivityController::class, 'index']);
    
    // Maintenance endpoints
    Route::get('/maintenance/schedule', [TruckMaintenanceController::class, 'getMaintenanceScheduleApi']);
    Route::post('/maintenance/request', [TruckMaintenanceController::class, 'submitMaintenanceRequestApi']);
    Route::post('/update-fcm-token', [AuthController::class, 'updateFcmToken']);
});

// Endpoint materials dapat diakses publik
Route::get('/materials', [MaterialController::class, 'apiIndex']);

// Material NP endpoints
Route::get('/material-np', [MaterialNpApiController::class, 'index']);