<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                <?php echo e(__('Detail Maintenance')); ?> - <?php echo e($truck->plate_number); ?>

            </h2>
            <div class="flex space-x-2">
                <!-- Tombol Send Push Notification -->
                <button onclick="openPushNotificationModal()" 
                    class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-mobile-alt mr-2"></i>Push Notif
                </button>
                
                <!-- Tombol Send In-App Message -->
                <button onclick="openInAppMessageModal()" 
                    class="bg-purple-500 hover:bg-purple-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-comment-dots mr-2"></i>In-App Message
                </button>
                
                <a href="<?php echo e(route('truck-maintenances.edit', ['truck' => $truck, 'maintenance' => $maintenance])); ?>" 
                    class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-edit mr-2"></i>Edit
                </a>
                <a href="<?php echo e(route('trucks.show', $truck)); ?>" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    <i class="fas fa-arrow-left mr-2"></i>Kembali
                </a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Alert Messages -->
            <?php if(session('success')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            
            <?php if(session('error')): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <!-- Notification History -->
                    <?php if(
                        $maintenance->last_manual_push_sent_at || 
                        $maintenance->last_manual_inapp_sent_at || 
                        $maintenance->manual_push_count > 0 || 
                        $maintenance->manual_inapp_count > 0
                    ): ?>
                        <div class="bg-blue-50 p-4 rounded-lg mb-6">
                            <h3 class="text-lg font-semibold mb-4 text-blue-800">
                                <i class="fas fa-history mr-2"></i>Riwayat Notifikasi Manual
                            </h3>
                            <div class="grid grid-cols-2 gap-6">
                                <!-- Push Notification History -->
                                <div class="bg-white p-3 rounded border">
                                    <h4 class="font-medium text-blue-700 mb-2">
                                        <i class="fas fa-mobile-alt mr-1"></i>Push Notification
                                    </h4>
                                    <div class="text-sm space-y-1">
                                        <div>
                                            <span class="text-gray-600">Terakhir dikirim:</span>
                                            <span class="font-medium">
                                                <?php echo e($maintenance->last_manual_push_sent_at ? $maintenance->last_manual_push_sent_at->format('d/m/Y H:i') : 'Belum pernah'); ?>

                                            </span>
                                        </div>
                                        <div>
                                            <span class="text-gray-600">Total dikirim:</span>
                                            <span class="font-medium"><?php echo e($maintenance->manual_push_count); ?> kali</span>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- In-App Message History -->
                                <div class="bg-white p-3 rounded border">
                                    <h4 class="font-medium text-purple-700 mb-2">
                                        <i class="fas fa-comment-dots mr-1"></i>In-App Message
                                    </h4>
                                    <div class="text-sm space-y-1">
                                        <div>
                                            <span class="text-gray-600">Terakhir dikirim:</span>
                                            <span class="font-medium">
                                                <?php echo e($maintenance->last_manual_inapp_sent_at ? $maintenance->last_manual_inapp_sent_at->format('d/m/Y H:i') : 'Belum pernah'); ?>

                                            </span>
                                        </div>
                                        <div>
                                            <span class="text-gray-600">Total dikirim:</span>
                                            <span class="font-medium"><?php echo e($maintenance->manual_inapp_count); ?> kali</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Maintenance</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div class="text-gray-600">Tanggal:</div>
                                <div class="font-medium"><?php echo e($maintenance->maintenance_date->format('d/m/Y')); ?></div>
                                
                                <div class="text-gray-600">Tipe:</div>
                                <div class="font-medium"><?php echo e(ucfirst(str_replace('_', ' ', $maintenance->maintenance_type))); ?></div>
                                
                                <div class="text-gray-600">Status:</div>
                                <div>
                                    <span class="px-2 py-1 rounded text-xs font-semibold
                                        <?php echo e($maintenance->status == 'completed' ? 'bg-green-100 text-green-800' : ''); ?>

                                        <?php echo e($maintenance->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : ''); ?>

                                        <?php echo e($maintenance->status == 'in_progress' ? 'bg-blue-100 text-blue-800' : ''); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $maintenance->status))); ?>

                                    </span>
                                </div>
                                
                                <div class="text-gray-600">Biaya:</div>
                                <div class="font-medium">Rp <?php echo e(number_format($maintenance->cost, 0, ',', '.')); ?></div>
                                
                                <div class="text-gray-600">Lokasi:</div>
                                <div class="font-medium"><?php echo e($maintenance->location); ?></div>
                                
                                <div class="text-gray-600">Dikerjakan Oleh:</div>
                                <div class="font-medium"><?php echo e($maintenance->performed_by); ?></div>
                            </div>
                        </div>
                        
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Informasi Tambahan</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <?php if($maintenance->odometer_reading): ?>
                                    <div class="text-gray-600">Kilometer (KM):</div>
                                    <div class="font-medium"><?php echo e(number_format($maintenance->odometer_reading, 0, ',', '.')); ?> KM</div>
                                <?php endif; ?>
                                
                                <?php if($maintenance->next_maintenance_date): ?>
                                    <div class="text-gray-600">Maintenance Berikutnya:</div>
                                    <div class="font-medium"><?php echo e($maintenance->next_maintenance_date->format('d/m/Y')); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-6 bg-gray-50 p-4 rounded-lg">
                        <h3 class="text-lg font-semibold mb-4 border-b pb-2">Deskripsi Pekerjaan</h3>
                        <p class="whitespace-pre-line"><?php echo e($maintenance->description); ?></p>
                    </div>
                    
                    <?php if($maintenance->notes): ?>
                        <div class="mt-6 bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">Catatan Tambahan</h3>
                            <p class="whitespace-pre-line"><?php echo e($maintenance->notes); ?></p>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($maintenance->image_path): ?>
                        <div class="mt-6 bg-gray-50 p-4 rounded-lg">
                            <h3 class="text-lg font-semibold mb-4 border-b pb-2">
                                <i class="fas fa-camera mr-2"></i>Foto dari Driver
                            </h3>
                            <div class="flex justify-center">
                                <img src="<?php echo e(asset('storage/' . $maintenance->image_path)); ?>" 
                                     alt="Foto Maintenance Request" 
                                     class="max-w-full h-auto rounded-lg shadow-lg cursor-pointer"
                                     onclick="openImageModal(this.src)">
                            </div>
                            <?php if($maintenance->requested_by): ?>
                                <p class="text-sm text-gray-600 mt-2 text-center">
                                    Diunggah oleh: <?php echo e($maintenance->requestedBy->name ?? 'Driver'); ?> 
                                    pada <?php echo e($maintenance->requested_at?->format('d/m/Y H:i')); ?>

                                </p>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modal for Push Notification -->
    <div id="pushNotificationModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <h3 class="text-lg font-medium text-gray-900 mb-4">
                    <i class="fas fa-mobile-alt mr-2 text-blue-500"></i>Kirim Push Notification
                </h3>
                
                <form action="<?php echo e(route('truck-maintenances.send-push-notification', ['truck' => $truck, 'maintenance' => $maintenance])); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="mb-4">
                        <label for="push_message" class="block text-sm font-medium text-gray-700 mb-2">
                            Pesan Push Notification (Opsional)
                        </label>
                        <textarea 
                            id="push_message" 
                            name="message" 
                            rows="3" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="Kosongkan untuk menggunakan pesan default..."></textarea>
                        <p class="text-xs text-gray-500 mt-1">
                            Default: "Pengingat maintenance <?php echo e($maintenance->maintenance_type); ?> untuk <?php echo e($truck->license_plate); ?>"
                        </p>
                    </div>
                    
                    <div class="flex justify-end space-x-2">
                        <button type="button" onclick="closePushNotificationModal()" 
                            class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                            Batal
                        </button>
                        <button type="submit" 
                            class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                            <i class="fas fa-paper-plane mr-2"></i>Kirim Push Notif
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Modal for In-App Message -->
    <div id="inAppMessageModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <h3 class="text-lg font-medium text-gray-900 mb-4">
                    <i class="fas fa-comment-dots mr-2 text-purple-500"></i>Kirim In-App Message
                </h3>
                
                <form action="<?php echo e(route('truck-maintenances.send-inapp-message', ['truck' => $truck, 'maintenance' => $maintenance])); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="mb-4">
                        <label for="inapp_message" class="block text-sm font-medium text-gray-700 mb-2">
                            Pesan In-App Message (Opsional)
                        </label>
                        <textarea 
                            id="inapp_message" 
                            name="message" 
                            rows="3" 
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500"
                            placeholder="Kosongkan untuk menggunakan pesan default..."></textarea>
                        <p class="text-xs text-gray-500 mt-1">
                            Default: "Pengingat maintenance <?php echo e($maintenance->maintenance_type); ?> untuk <?php echo e($truck->license_plate); ?>"
                        </p>
                        <p class="text-xs text-blue-600 mt-2">
                            <i class="fas fa-info-circle mr-1"></i>In-app message akan muncul di dalam aplikasi mobile saat dibuka.
                        </p>
                    </div>
                    
                    <div class="flex justify-end space-x-2">
                        <button type="button" onclick="closeInAppMessageModal()" 
                            class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                            Batal
                        </button>
                        <button type="submit" 
                            class="px-4 py-2 bg-purple-500 text-white rounded hover:bg-purple-600">
                            <i class="fas fa-comment-dots mr-2"></i>Kirim In-App Message
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Image Modal -->
    <div id="imageModal" class="fixed inset-0 bg-black bg-opacity-75 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-10 mx-auto p-5 w-11/12 max-w-4xl">
            <div class="bg-white rounded-lg p-4">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-medium">Foto Maintenance Request</h3>
                    <button onclick="closeImageModal()" class="text-gray-500 hover:text-gray-700">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>
                <div class="text-center">
                    <img id="modalImage" src="" alt="Foto Maintenance" class="max-w-full h-auto rounded">
                </div>
            </div>
        </div>
    </div>

    <script>
        // Push Notification Modal Functions
        function openPushNotificationModal() {
            document.getElementById('pushNotificationModal').classList.remove('hidden');
        }
        
        function closePushNotificationModal() {
            document.getElementById('pushNotificationModal').classList.add('hidden');
        }
        
        // In-App Message Modal Functions
        function openInAppMessageModal() {
            document.getElementById('inAppMessageModal').classList.remove('hidden');
        }
        
        function closeInAppMessageModal() {
            document.getElementById('inAppMessageModal').classList.add('hidden');
        }
        
        // Close modals when clicking outside
        document.getElementById('pushNotificationModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closePushNotificationModal();
            }
        });
        
        document.getElementById('inAppMessageModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeInAppMessageModal();
            }
        });

        // Image Modal Functions
        function openImageModal(imageSrc) {
            document.getElementById('modalImage').src = imageSrc;
            document.getElementById('imageModal').classList.remove('hidden');
        }

        function closeImageModal() {
            document.getElementById('imageModal').classList.add('hidden');
        }

        document.getElementById('imageModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeImageModal();
            }
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\wamp64\www\obm\resources\views/truck-maintenances/show.blade.php ENDPATH**/ ?>