<?php

namespace App\Console\Commands;

use App\Models\Driver;
use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class CreateDriverUsers extends Command
{
    protected $signature = 'drivers:create-users';
    protected $description = 'Create user accounts for existing drivers and assign driver role';

    public function handle()
    {
        $drivers = Driver::all();
        $this->info("Found {$drivers->count()} drivers.\n");

        $bar = $this->output->createProgressBar($drivers->count());
        $bar->start();

        foreach ($drivers as $driver) {
            // Generate email dari nama driver
            $email = Str::slug($driver->name, '.') . '@obm.com';
            $username = Str::slug($driver->name, '_');
            $counter = 1;

            // Pastikan email dan username unik
            while (User::where('email', $email)->exists()) {
                $email = Str::slug($driver->name, '.') . $counter . '@obm.com';
                $counter++;
            }

            $counter = 1;
            while (User::where('username', $username)->exists()) {
                $username = Str::slug($driver->name, '_') . '_' . $counter;
                $counter++;
            }

            // Buat user baru
            $user = User::create([
                'name' => $driver->name,
                'email' => $email,
                'username' => $username,
                'password' => Hash::make('password'), // Password default
                'email_verified_at' => now(),
                'remember_token' => Str::random(10),
            ]);

            // Update driver dengan email yang sama
            $driver->update(['email' => $email]);

            // Berikan role driver
            $user->assignRole('driver');

            $bar->advance();
        }

        $bar->finish();
        $this->newLine(2);
        $this->info('User accounts created and driver role assigned successfully!');

        return Command::SUCCESS;
    }
}