<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class GenerateDriverUsernames extends Command
{
    protected $signature = 'drivers:generate-usernames';
    protected $description = 'Generate usernames for existing drivers';

    public function handle()
    {
        $drivers = User::whereHas('roles', function($query) {
            $query->where('slug', 'driver');
        })->get();

        $this->info("Found {$drivers->count()} drivers.");

        $bar = $this->output->createProgressBar($drivers->count());
        $bar->start();

        foreach ($drivers as $driver) {
            // Generate username dari nama driver (contoh: john_doe)
            $baseUsername = Str::slug(Str::before($driver->email, '@'), '_');
            $username = $baseUsername;
            $counter = 1;

            // Pastikan username unik
            while (User::where('username', $username)->where('id', '!=', $driver->id)->exists()) {
                $username = $baseUsername . '_' . $counter;
                $counter++;
            }

            // Update user dengan username baru
            $driver->username = $username;
            $driver->save();

            $bar->advance();
        }

        $bar->finish();
        $this->newLine();
        $this->info('Usernames generated successfully!');

        return Command::SUCCESS;
    }
}
