<?php

namespace App\Console\Commands;

use App\Models\FuelPurchase;
use App\Models\FuelStock;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class InitializeFuelStock extends Command
{
    protected $signature = 'fuel:initialize-stock';
    protected $description = 'Initialize fuel stock based on existing fuel purchases';

    public function handle()
    {
        $this->info('Initializing fuel stock...');

        // Hapus data stok yang ada
        FuelStock::truncate();
        $this->info('Existing stock data cleared.');

        // Ambil semua jenis BBM yang ada
        $fuelTypes = FuelPurchase::select('fuel_type')->distinct()->get();
        $this->info('Found ' . $fuelTypes->count() . ' fuel types.');

        // Hitung total pembelian per jenis BBM
        foreach ($fuelTypes as $type) {
            $fuelType = $type->fuel_type;
            $totalQuantity = FuelPurchase::where('fuel_type', $fuelType)->sum('quantity');

            // Buat record stok baru
            FuelStock::create([
                'fuel_type' => $fuelType,
                'current_stock' => $totalQuantity,
                'initial_stock' => $totalQuantity,
                'last_updated' => now(),
                'notes' => 'Initialized from existing purchases',
            ]);

            $this->info("Created stock for {$fuelType}: {$totalQuantity} liters.");
        }

        $this->info('Fuel stock initialization completed successfully!');
        return 0;
    }
}
