<?php

namespace App\Exports;

use App\Models\Income;
use Illuminate\Support\Collection;

class IncomesExport
{
    public function collection(): Collection
    {
        $incomes = Income::with(['project', 'addedBy', 'approvedBy'])->get();
        
        return $incomes->map(function ($income) {
            return [
                'ID' => $income->id,
                'Judul' => $income->title,
                'Deskripsi' => $income->description,
                'Jumlah' => $income->amount,
                'Tanggal' => $income->income_date->format('d/m/Y'),
                'Proyek' => $income->project ? $income->project->name : 'Tidak ada',
                'Kategori' => $income->category,
                'Metode Pembayaran' => $income->payment_method,
                'Nomor Kwitansi' => $income->receipt_number,
                'Bukti Pembayaran' => $income->payment_proof ? 'Ada' : 'Tidak ada',
                'Status Approval' => ucfirst($income->approval_status),
                'Disetujui/Ditolak Oleh' => $income->approvedBy ? $income->approvedBy->name : '-',
                'Tanggal Approval' => $income->approved_at ? $income->approved_at->format('d/m/Y H:i') : '-',
                'Ditambahkan Oleh' => $income->addedBy->name,
                'Tanggal Dibuat' => $income->created_at->format('d/m/Y H:i'),
                'Terakhir Diperbarui' => $income->updated_at->format('d/m/Y H:i'),
            ];
        });
    }
}