<?php

namespace App\Http\Controllers;

use App\Models\MaterialNp;
use Illuminate\Http\Request;

class MaterialNpController extends Controller
{
    public function index(Request $request)
    {
        $query = MaterialNp::query();
        if ($request->filled('q')) {
            $query->where('name', 'like', '%' . $request->q . '%');
        }
        $materials = $query->orderBy('name')->paginate(10);
        return view('material-np.index', compact('materials'));
    }

    public function create()
    {
        return view('material-np.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'unit' => 'required|string|max:50',
        ]);
        MaterialNp::create($request->only('name', 'unit'));
        return redirect()->route('material-np.index')->with('success', 'Material-NP berhasil ditambahkan.');
    }

    public function show($id)
    {
        $material = MaterialNp::findOrFail($id);
        return view('material-np.show', compact('material'));
    }

    public function edit($id)
    {
        $material = MaterialNp::findOrFail($id);
        return view('material-np.edit', compact('material'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'unit' => 'required|string|max:50',
        ]);
        $material = MaterialNp::findOrFail($id);
        $material->update($request->only('name', 'unit'));
        return redirect()->route('material-np.index')->with('success', 'Material-NP berhasil diupdate.');
    }

    public function destroy($id)
    {
        $material = MaterialNp::findOrFail($id);
        $material->delete();
        return redirect()->route('material-np.index')->with('success', 'Material-NP berhasil dihapus.');
    }
}
