<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class FuelPurchase extends Model
{
    protected $fillable = [
        'truck_id',
        'purchase_date',
        'quantity',
        'price_per_liter',
        'total_cost',
        'fuel_type',
        'station_name',
        'receipt_number',
        'receipt_image',
        'driver_name',
        'notes'
    ];

    protected $casts = [
        'purchase_date' => 'date',
        'quantity' => 'decimal:2',
        'price_per_liter' => 'decimal:2',
        'total_cost' => 'decimal:2',
    ];

    /**
     * Get the truck that owns the fuel purchase.
     */
    public function truck(): BelongsTo
    {
        return $this->belongsTo(Truck::class);
    }
    
    /**
     * Get the expense record associated with this fuel purchase.
     */
    public function expense(): HasOne
    {
        return $this->hasOne(Expense::class);
    }
    
    /**
     * Get the receipt image URL.
     */
    public function getReceiptImageUrlAttribute()
    {
        if ($this->receipt_image) {
            return asset('storage/' . $this->receipt_image);
        }
        return null;
    }
}
