<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FuelStockLog extends Model
{
    protected $fillable = [
        'fuel_type',
        'operation_type', // 'add' atau 'reduce'
        'quantity',
        'notes',
        'created_by',
        'operation_date'
    ];

    protected $casts = [
        'quantity' => 'decimal:2',
        'operation_date' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}