<?php

namespace App\Providers;

use App\Models\Announcement;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class ViewServiceProvider extends ServiceProvider
{
    public function boot()
    {
        View::composer('layouts.app', function ($view) {
            $announcements = Announcement::active()
                ->orderBy('created_at', 'desc')
                ->get();
            $view->with('announcements', $announcements);
        });
    }
}
