<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        if (Schema::hasTable('truck_maintenances')) {
            Schema::table('truck_maintenances', function (Blueprint $table) {
                $table->string('image_path')->nullable()->after('notes');
                $table->unsignedBigInteger('requested_by')->nullable()->after('image_path');
                $table->timestamp('requested_at')->nullable()->after('requested_by');
                
                // Add foreign key constraint for requested_by
                $table->foreign('requested_by')->references('id')->on('users')->onDelete('set null');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('truck_maintenances', function (Blueprint $table) {
            $table->dropForeign(['requested_by']);
            $table->dropColumn(['image_path', 'requested_by', 'requested_at']);
        });
    }
};