<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('announcements', function (Blueprint $table) {
            // MySQL requires special handling to modify enum
            DB::statement("ALTER TABLE announcements MODIFY type ENUM('news', 'reminder', 'alert', 'event', 'info', 'achievement')");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // First update any records with values that would be truncated
        DB::table('announcements')
            ->whereIn('type', ['event', 'info', 'achievement'])
            ->update(['type' => 'news']);
            
        Schema::table('announcements', function (Blueprint $table) {
            DB::statement("ALTER TABLE announcements MODIFY type ENUM('news', 'reminder', 'alert')");
        });
    }
};
