<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('trucks', function (Blueprint $table) {
            $table->date('stnk_expire_date')->nullable()->after('next_service_date');
            $table->string('stnk_number')->nullable()->after('stnk_expire_date');
            $table->date('kir_expire_date')->nullable()->after('stnk_number');
            $table->string('kir_number')->nullable()->after('kir_expire_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('trucks', function (Blueprint $table) {
            $table->dropColumn(['stnk_expire_date', 'stnk_number', 'kir_expire_date', 'kir_number']);
        });
    }
};