<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('trips', function (Blueprint $table) {
            // Cek apakah kolom belum ada sebelum menambahkan
            if (!Schema::hasColumn('trips', 'indikator_solar')) {
                $table->decimal('indikator_solar', 8, 2)->nullable()->after('fuel_consumption');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('trips', function (Blueprint $table) {
            // Cek apakah kolom ada sebelum menghapus
            if (Schema::hasColumn('trips', 'indikator_solar')) {
                $table->dropColumn('indikator_solar');
            }
        });
    }
};
