<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNotificationFieldsToTruckMaintenancesTable extends Migration
{
    public function up()
    {
        Schema::table('truck_maintenances', function (Blueprint $table) {
            $table->boolean('notification_sent')->default(false);
            $table->timestamp('last_notification_sent_at')->nullable();
        });
    }

    public function down()
    {
        Schema::table('truck_maintenances', function (Blueprint $table) {
            $table->dropColumn(['notification_sent', 'last_notification_sent_at']);
        });
    }
}