<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('fuel_stocks', function (Blueprint $table) {
            $table->string('fuel_type')->after('id'); // Solar, Bensin, Pertamax, dll
            $table->decimal('current_stock', 10, 2)->default(0)->after('fuel_type'); // dalam liter
            $table->decimal('initial_stock', 10, 2)->default(0)->after('current_stock'); // stok awal
            $table->date('last_updated')->after('initial_stock');
            $table->text('notes')->nullable()->after('last_updated');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fuel_stocks', function (Blueprint $table) {
            $table->dropColumn(['fuel_type', 'current_stock', 'initial_stock', 'last_updated', 'notes']);
        });
    }
};
