<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('driver_activities', function (Blueprint $table) {
            // Cek apakah kolom belum ada sebelum menambahkan
            if (!Schema::hasColumn('driver_activities', 'asal')) {
                $table->string('asal')->nullable()->after('plat_nomor');
            }
            if (!Schema::hasColumn('driver_activities', 'tujuan')) {
                $table->string('tujuan')->nullable()->after('asal');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('driver_activities', function (Blueprint $table) {
            $table->dropColumn(['asal', 'tujuan']);
        });
    }
};
