<?php

namespace Database\Seeders;

use App\Models\Announcement;
use Illuminate\Database\Seeder;

class AnnouncementSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Tipe pengumuman yang tersedia
        $types = ['news', 'reminder', 'alert', 'event', 'info', 'achievement'];
        
        // Buat beberapa pengumuman dengan data spesifik
        Announcement::create([
            'title' => 'Perubahan Jadwal Operasional',
            'content' => 'Mulai tanggal 1 Juli 2023, jam operasional kantor akan berubah menjadi 08.00 - 17.00 WIB.',
            'type' => 'info',
            'is_active' => true,
            'start_date' => now(),
            'end_date' => now()->addDays(14),
        ]);
        
        Announcement::create([
            'title' => 'Pelatihan Keselamatan Kerja',
            'content' => 'Seluruh pengemudi wajib mengikuti pelatihan keselamatan kerja pada tanggal 15 Juli 2023.',
            'type' => 'reminder',
            'is_active' => true,
            'start_date' => now(),
            'end_date' => now()->addDays(10),
        ]);
        
        Announcement::create([
            'title' => 'Pemeliharaan Sistem',
            'content' => 'Sistem akan mengalami pemeliharaan pada tanggal 10 Juli 2023 pukul 22.00 - 24.00 WIB.',
            'type' => 'alert',
            'is_active' => true,
            'start_date' => now()->addDays(5),
            'end_date' => now()->addDays(7),
        ]);
        
        Announcement::create([
            'title' => 'Acara Gathering Perusahaan',
            'content' => 'Acara gathering perusahaan akan diadakan pada tanggal 20 Juli 2023 di Hotel Grand Hyatt Jakarta.',
            'type' => 'event',
            'is_active' => true,
            'start_date' => now(),
            'end_date' => now()->addDays(20),
        ]);
        
        Announcement::create([
            'title' => 'Penghargaan Driver Terbaik',
            'content' => 'Selamat kepada Budi Santoso yang telah terpilih sebagai driver terbaik bulan Juni 2023.',
            'type' => 'achievement',
            'is_active' => true,
            'start_date' => now()->subDays(5),
            'end_date' => now()->addDays(10),
        ]);
        
        // Buat 10 pengumuman acak
        for ($i = 0; $i < 10; $i++) {
            $startDate = fake()->optional(0.8)->dateTimeBetween('-10 days', '+30 days');
            $endDate = $startDate ? fake()->optional(0.8)->dateTimeBetween($startDate, '+60 days') : null;
            
            Announcement::create([
                'title' => fake()->sentence(),
                'content' => fake()->paragraph(3),
                'type' => fake()->randomElement($types),
                'is_active' => fake()->boolean(80), // 80% kemungkinan aktif
                'start_date' => $startDate,
                'end_date' => $endDate,
            ]);
        }
    }
}