<?php

namespace Database\Seeders;

use App\Models\Driver;
use App\Models\Truck;
use Illuminate\Database\Seeder;

class DriverSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Dapatkan semua truck yang aktif
        $activeTrucks = Truck::where('status', 'active')->pluck('id')->toArray();
        
        // Buat 5 driver dengan truck yang ditetapkan
        Driver::factory(5)->create([
            'status' => 'aktif',
            'truck_id' => function () use ($activeTrucks) {
                // Pastikan masih ada truck yang tersedia
                if (count($activeTrucks) > 0) {
                    $truckId = array_shift($activeTrucks);
                    return $truckId;
                }
                return null;
            }
        ]);
        
        // Buat 3 driver tanpa truck (cadangan)
        Driver::factory(3)->create([
            'status' => 'aktif',
            'truck_id' => null
        ]);
        
        // Buat 2 driver tidak aktif
        Driver::factory(2)->create([
            'status' => 'tidak aktif',
            'truck_id' => null
        ]);
        
        // Buat driver dengan data spesifik
        Driver::create([
            'name' => 'Budi Santoso',
            'id_number' => '3275012345678901',
            'license_number' => 'SIM123456',
            'license_expiry' => '2025-12-31',
            'phone' => '081234567890',
            'address' => 'Jl. Raya Bogor No. 123, Jakarta Timur',
            'status' => 'aktif',
            'join_date' => '2020-01-15',
            'exit_date' => null,
            'notes' => 'Pengemudi senior dengan pengalaman lebih dari 10 tahun',
            'emergency_contact' => '081987654321',
            'blood_type' => 'O+',
            'profile_photo' => null,
            'salary' => 7500000,
            'truck_id' => Truck::where('plate_number', 'B1234KLM')->first()->id ?? null
        ]);
    }
}
