<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Permissions untuk manajemen pengguna
        Permission::firstOrCreate(['slug' => 'view-users'], ['name' => 'Lihat Pengguna']);
        Permission::firstOrCreate(['slug' => 'create-users'], ['name' => 'Buat Pengguna']);
        Permission::firstOrCreate(['slug' => 'edit-users'], ['name' => 'Edit Pengguna']);
        Permission::firstOrCreate(['slug' => 'delete-users'], ['name' => 'Hapus Pengguna']);

        // Permissions untuk manajemen armada
        Permission::firstOrCreate(['slug' => 'view-trucks'], ['name' => 'Lihat Truk']);
        Permission::firstOrCreate(['slug' => 'create-trucks'], ['name' => 'Buat Truk']);
        Permission::firstOrCreate(['slug' => 'edit-trucks'], ['name' => 'Edit Truk']);
        Permission::firstOrCreate(['slug' => 'delete-trucks'], ['name' => 'Hapus Truk']);

        // Permissions untuk manajemen driver
        Permission::firstOrCreate(['slug' => 'view-drivers'], ['name' => 'Lihat Driver']);
        Permission::firstOrCreate(['slug' => 'create-drivers'], ['name' => 'Buat Driver']);
        Permission::firstOrCreate(['slug' => 'edit-drivers'], ['name' => 'Edit Driver']);
        Permission::firstOrCreate(['slug' => 'delete-drivers'], ['name' => 'Hapus Driver']);
        Permission::firstOrCreate(['slug' => 'view-driver-retase'], ['name' => 'Lihat Retase Driver']);

        // Permissions untuk manajemen perjalanan
        Permission::firstOrCreate(['slug' => 'view-trips'], ['name' => 'Lihat Perjalanan']);
        Permission::firstOrCreate(['slug' => 'create-trips'], ['name' => 'Buat Perjalanan']);
        Permission::firstOrCreate(['slug' => 'edit-trips'], ['name' => 'Edit Perjalanan']);
        Permission::firstOrCreate(['slug' => 'delete-trips'], ['name' => 'Hapus Perjalanan']);

        // Permissions untuk manajemen proyek
        Permission::firstOrCreate(['slug' => 'view-projects'], ['name' => 'Lihat Proyek']);
        Permission::firstOrCreate(['slug' => 'create-projects'], ['name' => 'Buat Proyek']);
        Permission::firstOrCreate(['slug' => 'edit-projects'], ['name' => 'Edit Proyek']);
        Permission::firstOrCreate(['slug' => 'delete-projects'], ['name' => 'Hapus Proyek']);

        // Permissions untuk laporan
        Permission::firstOrCreate(['slug' => 'view-reports'], ['name' => 'Lihat Laporan']);
        Permission::firstOrCreate(['slug' => 'export-reports'], ['name' => 'Ekspor Laporan']);

        // Permissions untuk pengaturan
        Permission::firstOrCreate(['slug' => 'view-settings'], ['name' => 'Lihat Pengaturan']);
        Permission::firstOrCreate(['slug' => 'edit-settings'], ['name' => 'Edit Pengaturan']);

        Permission::firstOrCreate(
            ['slug' => 'manage-users'],
            [
                'name' => 'Kelola Pengguna',
                'description' => 'Dapat mengelola pengguna sistem',
            ]
        );

        Permission::firstOrCreate(
            ['slug' => 'manage-roles'],
            [
                'name' => 'Kelola Peran',
                'description' => 'Dapat mengelola peran dalam sistem',
            ]
        );

        Permission::firstOrCreate(
            ['slug' => 'manage-permissions'],
            [
                'name' => 'Kelola Izin',
                'description' => 'Dapat mengelola izin dalam sistem',
            ]
        );

        Permission::firstOrCreate(
            ['slug' => 'access-settings'],
            [
                'name' => 'Akses Pengaturan Sistem',
                'description' => 'Dapat mengakses dan mengubah pengaturan sistem',
            ]
        );

        // Permissions untuk retase manual
        Permission::firstOrCreate([
            'name' => 'Manage Manual Trip Counts',
            'slug' => 'manage-manual-trip-counts',
        ]);

        // Tambahkan permission untuk manajemen keuangan
        Permission::firstOrCreate(
            ['slug' => 'manage-finances'],
            [
                'name' => 'Kelola Keuangan',
                'description' => 'Dapat mengelola data keuangan (pendapatan dan pengeluaran)',
            ]
        );
        // Tambahkan permission baru
        Permission::firstOrCreate(
            ['slug' => 'approve-finances'],
            [
                'name' => 'Menyetujui Keuangan',
                'description' => 'Dapat menyetujui atau menolak transaksi keuangan',
            ]
        );
    }
}