<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // General Settings
        Setting::set('app_name', 'OBM - Operation Business Management', 'general', 'text', 'Nama aplikasi', 'Nama yang akan ditampilkan di judul browser dan header aplikasi');
        Setting::set('app_version', '1.0.0', 'general', 'text', 'Versi aplikasi', 'Versi saat ini dari aplikasi');
        Setting::set('app_mode', 'production', 'general', 'select', 'Mode aplikasi', 'Mode operasi aplikasi', json_encode([
            'production' => 'Production',
            'development' => 'Development',
            'maintenance' => 'Maintenance'
        ]));
        Setting::set('logo', 'images/logo.png', 'general', 'file', 'Logo aplikasi', 'Logo yang akan ditampilkan di header dan laporan');
        
        // Company Information
        Setting::set('company_name', 'PT. Example', 'general', 'text', 'Nama perusahaan', 'Nama resmi perusahaan');
        Setting::set('company_address', 'Jl. Example No. 123', 'general', 'textarea', 'Alamat perusahaan', 'Alamat lengkap perusahaan');
        Setting::set('company_phone', '021-1234567', 'general', 'text', 'Nomor telepon perusahaan', 'Nomor telepon utama perusahaan');
        Setting::set('company_email', 'info@example.com', 'general', 'text', 'Email perusahaan', 'Alamat email resmi perusahaan');
        Setting::set('company_website', 'https://example.com', 'general', 'text', 'Website perusahaan', 'Alamat website resmi perusahaan');
        Setting::set('company_tax_id', '01.234.567.8-123.000', 'general', 'text', 'NPWP Perusahaan', 'Nomor Pokok Wajib Pajak perusahaan');
        
        // Technical Contact
        Setting::set('admin_name', 'Administrator', 'general', 'text', 'Nama Admin', 'Nama administrator sistem');
        Setting::set('admin_email', 'admin@example.com', 'general', 'text', 'Email Admin', 'Alamat email administrator sistem');
        Setting::set('admin_phone', '081234567890', 'general', 'text', 'Nomor Telepon Admin', 'Nomor telepon administrator sistem');
        
        // System Settings
        Setting::set('items_per_page', '15', 'general', 'number', 'Item Per Halaman', 'Jumlah item yang ditampilkan per halaman');
        Setting::set('enable_system_logs', 'true', 'general', 'boolean', 'Aktifkan Log Sistem', 'Mengaktifkan pencatatan log sistem');
        Setting::set('log_retention_days', '30', 'general', 'number', 'Periode Retensi Log (hari)', 'Jumlah hari log sistem disimpan sebelum dihapus otomatis');
        
        // Email Settings
        Setting::set('mail_driver', 'smtp', 'email', 'text', 'Driver email');
        Setting::set('mail_host', 'smtp.example.com', 'email', 'text', 'Host SMTP');
        Setting::set('mail_port', '587', 'email', 'number', 'Port SMTP');
        Setting::set('mail_username', 'username', 'email', 'text', 'Username SMTP');
        Setting::set('mail_password', 'password', 'email', 'text', 'Password SMTP');
        Setting::set('mail_encryption', 'tls', 'email', 'text', 'Enkripsi SMTP');
        Setting::set('mail_from_address', 'noreply@example.com', 'email', 'text', 'Alamat email pengirim');
        Setting::set('mail_from_name', 'OBM System', 'email', 'text', 'Nama pengirim email');
        
        // Date & Time Settings
        $timezones = [
            'Asia/Jakarta' => 'Asia/Jakarta (WIB)',
            'Asia/Makassar' => 'Asia/Makassar (WITA)',
            'Asia/Jayapura' => 'Asia/Jayapura (WIT)',
            'Asia/Singapore' => 'Asia/Singapore',
            'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
            'Asia/Bangkok' => 'Asia/Bangkok',
            'Asia/Hong_Kong' => 'Asia/Hong_Kong',
            'Asia/Tokyo' => 'Asia/Tokyo',
            'Australia/Sydney' => 'Australia/Sydney',
            'Europe/London' => 'Europe/London',
            'America/New_York' => 'America/New_York',
            'UTC' => 'UTC',
        ];
        
        Setting::set('timezone', 'Asia/Jakarta', 'datetime', 'select', 'Zona waktu', 'Pilih zona waktu untuk aplikasi', json_encode($timezones));
        Setting::set('date_format', 'Y-m-d', 'datetime', 'text', 'Format tanggal');
        Setting::set('time_format', 'H:i', 'datetime', 'text', 'Format waktu');
        
        // Appearance Settings
        Setting::set('theme', 'default', 'appearance', 'text', 'Tema aplikasi');
        Setting::set('sidebar_collapsed', 'false', 'appearance', 'boolean', 'Sidebar collapsed by default');
        Setting::set('logo', 'images/logo.png', 'appearance', 'text', 'Logo aplikasi');
        
        // Notification Settings
        Setting::set('enable_email_notifications', 'true', 'notification', 'boolean', 'Aktifkan notifikasi email');
        Setting::set('enable_browser_notifications', 'true', 'notification', 'boolean', 'Aktifkan notifikasi browser');
    }
}
